/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.network.merge.internal.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.cytoscape.network.merge.internal.ui.IDMappingDialog;
import org.cytoscape.network.merge.internal.ui.RowTableCellEditor;

public class IDTypeSelectionTable
extends JTable {
    private IDTypeSelectionTableModel model;
    private Frame frame;
    private IDMappingDialog parent;
    private Set<String> supportedSrcIDType;
    private List<String[]> listNetIDTitleAttr;

    public IDTypeSelectionTable(Frame frame, IDMappingDialog parent) {
        this.frame = frame;
        this.parent = parent;
        this.initNetworks();
        this.supportedSrcIDType = new TreeSet<String>();
        this.model = new IDTypeSelectionTableModel();
        this.setModel(this.model);
        this.setRowHeight(20);
        this.setColumnEditorAndCellRenderer();
    }

    public void setSupportedSrcIDType(Set<String> types) {
        this.supportedSrcIDType = new TreeSet<String>(types);
        this.model = new IDTypeSelectionTableModel();
        this.setModel(this.model);
        this.setColumnEditorAndCellRenderer();
    }

    protected void setColumnEditorAndCellRenderer() {
        int nc = this.getColumnCount();
        TableColumn column = this.getColumnModel().getColumn(nc - 1);
        RowTableCellEditor rowEditor = new RowTableCellEditor(this);
        int nr = this.getRowCount();
        ArrayList<CheckComboBox> combos = new ArrayList<CheckComboBox>(nr);
        for (int ir = 0; ir < nr; ++ir) {
            String net = this.getNetIDAt(ir);
            String attr = (String)this.getValueAt(ir, 1);
            CheckComboBox cc = new CheckComboBox(net, attr);
            combos.add(cc);
            rowEditor.setEditorAt(ir, new DefaultCellEditor(cc));
        }
        column.setCellEditor(rowEditor);
        if (this.supportedSrcIDType.isEmpty()) {
            column.setCellRenderer(new TableCellRenderer(){
                private DefaultTableCellRenderer defaultRenderer = new DefaultTableCellRenderer();

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JLabel label = (JLabel)this.defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (isSelected) {
                        label.setBackground(table.getSelectionBackground());
                        label.setForeground(table.getSelectionForeground());
                    } else {
                        label.setBackground(table.getBackground());
                        label.setForeground(table.getForeground());
                    }
                    label.setToolTipText("Please select a non-empty ID mapping file first.");
                    return label;
                }
            });
        } else {
            column.setCellRenderer(new ComboBoxTableCellRenderer(combos));
        }
    }

    private void initNetworks() {
        Map<String, Map<String, Set<String>>> selectedNetworkAttributeIDType = this.parent.getSrcTypes();
        ArrayList<String> netTitles = new ArrayList<String>();
        ArrayList<String> netIDs = new ArrayList<String>();
        int size = 0;
        Iterator<String> it = selectedNetworkAttributeIDType.keySet().iterator();
        while (it.hasNext()) {
            int index;
            String netID;
            String netName = netID = it.next();
            for (index = 0; index < size && ((String)netTitles.get(index)).compareToIgnoreCase(netName) < 0; ++index) {
            }
            netIDs.add(index, netID);
            netTitles.add(index, netName);
            ++size;
        }
        this.listNetIDTitleAttr = new ArrayList<String[]>();
        int n = netIDs.size();
        for (int i = 0; i < n; ++i) {
            String id = (String)netIDs.get(i);
            for (String attr : selectedNetworkAttributeIDType.get(id).keySet()) {
                this.listNetIDTitleAttr.add(new String[]{id, (String)netTitles.get(i), attr});
            }
        }
    }

    private String getNetIDAt(int row) {
        String[] strs = this.listNetIDTitleAttr.get(row);
        String netID = strs[0];
        return netID;
    }

    void fireTableDataChanged() {
        this.model.fireTableDataChanged();
    }

    class CheckBoxRenderer
    implements ListCellRenderer {
        private DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();
        private List<JCheckBox> cbs;
        private String net;
        private String attr;

        public CheckBoxRenderer(String net, String attr, List<JCheckBox> cbs) {
            IDTypeSelectionTable.this.setOpaque(true);
            this.cbs = cbs;
            this.net = net;
            this.attr = attr;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (index > 0) {
                JCheckBox cb = this.cbs.get(index - 1);
                cb.setBackground(isSelected ? Color.blue : Color.white);
                cb.setForeground(isSelected ? Color.white : Color.black);
                return cb;
            }
            TreeSet types = new TreeSet(IDTypeSelectionTable.this.parent.getSrcTypes().get(this.net).get(this.attr));
            return this.defaultRenderer.getListCellRendererComponent((JList<?>)list, ((Object)types).toString(), index, isSelected, cellHasFocus);
        }
    }

    class CheckComboBox
    extends JComboBox {
        private List<JCheckBox> cbs;
        private String net;
        private String attr;

        public CheckComboBox(String net, String attr) {
            this.net = net;
            this.attr = attr;
            this.initCBs();
            this.addItem(new String());
            for (JCheckBox cb : this.cbs) {
                this.addItem(cb);
            }
            this.setRenderer(new CheckBoxRenderer(net, attr, this.cbs));
            this.addActionListener(this);
        }

        private void initCBs() {
            JCheckBox cb;
            Set<String> selectedTypes = IDTypeSelectionTable.this.parent.getSrcTypes().get(this.net).get(this.attr);
            this.cbs = new ArrayList<JCheckBox>();
            for (String type : IDTypeSelectionTable.this.supportedSrcIDType) {
                cb = new JCheckBox(type);
                cb.setSelected(selectedTypes.contains(type));
                this.cbs.add(cb);
            }
            cb = new JCheckBox("Select all");
            cb.setSelected(selectedTypes.size() == IDTypeSelectionTable.this.supportedSrcIDType.size());
            this.cbs.add(cb);
            cb = new JCheckBox("Select none");
            cb.setSelected(selectedTypes.isEmpty());
            this.cbs.add(cb);
        }

        private void checkBoxSelectionChanged(int index) {
            int n = this.cbs.size();
            if (index < 0 || index >= n) {
                return;
            }
            Set<String> selectedTypes = IDTypeSelectionTable.this.parent.getSrcTypes().get(this.net).get(this.attr);
            if (index < n - 2) {
                JCheckBox cb = this.cbs.get(index);
                if (cb.isSelected()) {
                    cb.setSelected(false);
                    selectedTypes.remove(cb.getText());
                    this.cbs.get(n - 2).setSelected(false);
                    this.cbs.get(n - 1).setSelected(selectedTypes.isEmpty());
                } else {
                    cb.setSelected(true);
                    selectedTypes.add(cb.getText());
                    this.cbs.get(n - 2).setSelected(selectedTypes.size() == IDTypeSelectionTable.this.supportedSrcIDType.size());
                    this.cbs.get(n - 1).setSelected(false);
                }
            } else if (index == n - 2) {
                selectedTypes.addAll(IDTypeSelectionTable.this.supportedSrcIDType);
                for (int i = 0; i < n - 1; ++i) {
                    this.cbs.get(i).setSelected(true);
                }
                this.cbs.get(n - 1).setSelected(false);
            } else {
                selectedTypes.clear();
                for (int i = 0; i < n - 1; ++i) {
                    this.cbs.get(i).setSelected(false);
                }
                this.cbs.get(n - 1).setSelected(true);
            }
            IDTypeSelectionTable.this.parent.updateGoButtonEnable();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int sel = this.getSelectedIndex();
            if (sel == 0) {
                this.getUI().setPopupVisible(this, false);
            } else if (sel > 0) {
                this.checkBoxSelectionChanged(sel - 1);
            }
            this.setSelectedIndex(-1);
        }

        @Override
        public void setPopupVisible(boolean flag) {
        }
    }

    class ComboBoxTableCellRenderer
    implements TableCellRenderer {
        private List<CheckComboBox> combos;

        public ComboBoxTableCellRenderer(List<CheckComboBox> combos) {
            this.combos = combos;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column == table.getColumnCount() - 1) {
                return this.combos.get(row);
            }
            DefaultTableCellRenderer defaultRenderer = new DefaultTableCellRenderer();
            return defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private class IDTypeSelectionTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{"Network", "Column", "ID Type(s)"};

        private IDTypeSelectionTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.getRowCount() == 0 ? 0 : 3;
        }

        @Override
        public int getRowCount() {
            return IDTypeSelectionTable.this.listNetIDTitleAttr.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public String getValueAt(int row, int col) {
            String[] strs = IDTypeSelectionTable.this.listNetIDTitleAttr.get(row);
            String netID = strs[0];
            String netTitle = strs[1];
            String attr = strs[2];
            switch (col) {
                case 0: {
                    return netTitle;
                }
                case 1: {
                    return attr;
                }
                case 2: {
                    return IDTypeSelectionTable.this.parent.getSrcTypes().get(netID).get(attr).toString();
                }
            }
            throw new IndexOutOfBoundsException();
        }

        public Class getColumnClass(int c) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == this.getColumnCount() - 1 && !IDTypeSelectionTable.this.supportedSrcIDType.isEmpty();
        }
    }
}

