/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.network.merge.internal.conflict;

import java.util.Map;
import java.util.TreeSet;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.network.merge.internal.conflict.AttributeConflictHandler;
import org.cytoscape.network.merge.internal.util.ColumnType;

public class DefaultAttributeConflictHandler
implements AttributeConflictHandler {
    @Override
    public boolean handleIt(CyIdentifiable to, CyColumn toColumn, Map<CyIdentifiable, CyColumn> mapFromGOFromAttr) {
        if (to == null || toColumn == null || mapFromGOFromAttr == null) {
            throw new NullPointerException("All parameters should not be null.");
        }
        CyTable table = toColumn.getTable();
        CyRow row = table.getRow((Object)to.getSUID());
        ColumnType type = ColumnType.getType(toColumn);
        if (type == ColumnType.STRING) {
            String toValue = (String)row.get(toColumn.getName(), String.class);
            TreeSet<String> values = new TreeSet<String>();
            values.add(toValue);
            for (Map.Entry<CyIdentifiable, CyColumn> entry : mapFromGOFromAttr.entrySet()) {
                CyIdentifiable from = entry.getKey();
                CyColumn fromColumn = entry.getValue();
                CyRow fromRow = fromColumn.getTable().getRow((Object)from.getSUID());
                String fromValue = (String)fromRow.get(fromColumn.getName(), String.class);
                if (fromValue == null) continue;
                values.add(fromValue.toString());
            }
            StringBuilder str = new StringBuilder();
            for (String v : values) {
                str.append(v + ";");
            }
            str.deleteCharAt(str.length() - 1);
            row.set(toColumn.getName(), (Object)str.toString());
            return true;
        }
        return false;
    }
}

