/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.force;

import java.util.Iterator;
import prefuse.util.force.ForceItem;
import prefuse.util.force.ForceSimulator;
import prefuse.util.force.Integrator;
import prefuse.util.force.StateMonitor;

public class EulerIntegrator
implements Integrator {
    private final StateMonitor monitor;

    public EulerIntegrator(StateMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public void integrate(ForceSimulator sim, long timestep) {
        float speedLimit = sim.getSpeedLimit();
        Iterator<ForceItem> iter = sim.getItems();
        while (iter.hasNext()) {
            if (this.monitor.isCancelled()) {
                return;
            }
            ForceItem item = iter.next();
            item.location[0] = item.location[0] + (float)timestep * item.velocity[0];
            item.location[1] = item.location[1] + (float)timestep * item.velocity[1];
            float coeff = (float)timestep / item.mass;
            item.velocity[0] = item.velocity[0] + coeff * item.force[0];
            item.velocity[1] = item.velocity[1] + coeff * item.force[1];
            float vx = item.velocity[0];
            float vy = item.velocity[1];
            float v = (float)Math.sqrt(vx * vx + vy * vy);
            if (!(v > speedLimit)) continue;
            item.velocity[0] = speedLimit * vx / v;
            item.velocity[1] = speedLimit * vy / v;
        }
    }
}

