/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.prefuse.layouts.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.cytoscape.model.CyNode;
import org.cytoscape.prefuse.layouts.internal.ForceDirectedLayout;
import org.cytoscape.prefuse.layouts.internal.ForceDirectedLayoutContext;
import org.cytoscape.view.layout.AbstractParallelPartitionLayoutTask;
import org.cytoscape.view.layout.LayoutEdge;
import org.cytoscape.view.layout.LayoutNode;
import org.cytoscape.view.layout.LayoutPartition;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.work.undo.UndoSupport;
import prefuse.util.force.DragForce;
import prefuse.util.force.ForceItem;
import prefuse.util.force.ForceSimulator;
import prefuse.util.force.NBodyForce;
import prefuse.util.force.SpringForce;
import prefuse.util.force.StateMonitor;

public class ForceDirectedLayoutTask
extends AbstractParallelPartitionLayoutTask {
    private ForceDirectedLayout.Integrators integrator;
    private final ForceDirectedLayoutContext context;
    private final StateMonitor monitor;

    public ForceDirectedLayoutTask(String displayName, CyNetworkView networkView, Set<View<CyNode>> nodesToLayOut, ForceDirectedLayoutContext context, ForceDirectedLayout.Integrators integrator, String attrName, UndoSupport undo) {
        super(displayName, context.singlePartition, networkView, nodesToLayOut, attrName, undo);
        this.context = context;
        this.integrator = integrator;
        this.edgeWeighter = context.edgeWeighter;
        this.edgeWeighter.setWeightAttribute(this.layoutAttribute);
        this.monitor = new StateMonitor();
    }

    public String toString() {
        return "Prefuse Force Directed Layout";
    }

    public void layoutPartition(LayoutPartition part) {
        ForceSimulator m_fsim = new ForceSimulator(this.monitor);
        m_fsim.addForce(new NBodyForce(this.monitor));
        m_fsim.addForce(new SpringForce());
        m_fsim.addForce(new DragForce());
        part.calculateEdgeWeights();
        m_fsim = new ForceSimulator(this.monitor);
        m_fsim.addForce(new NBodyForce(this.monitor));
        m_fsim.addForce(new SpringForce());
        m_fsim.addForce(new DragForce());
        List nodeList = part.getNodeList();
        List edgeList = part.getEdgeList();
        if (this.context.isDeterministic) {
            Collections.sort(nodeList);
            Collections.sort(edgeList);
        }
        HashMap<LayoutNode, ForceItem> forceItems = new HashMap<LayoutNode, ForceItem>();
        for (LayoutNode ln : nodeList) {
            if (this.cancelled) {
                return;
            }
            ForceItem fitem = (ForceItem)forceItems.get(ln);
            if (fitem == null) {
                fitem = new ForceItem();
                forceItems.put(ln, fitem);
            }
            fitem.mass = this.getMassValue(ln);
            fitem.location[0] = 0.0f;
            fitem.location[1] = 0.0f;
            m_fsim.addItem(fitem);
        }
        for (LayoutEdge e : edgeList) {
            if (this.cancelled) {
                return;
            }
            LayoutNode n1 = e.getSource();
            ForceItem f1 = (ForceItem)forceItems.get(n1);
            LayoutNode n2 = e.getTarget();
            ForceItem f2 = (ForceItem)forceItems.get(n2);
            if (f1 == null || f2 == null) continue;
            m_fsim.addSpring(f1, f2, this.getSpringCoefficient(e), this.getSpringLength(e));
        }
        long timestep = 1000L;
        for (int i = 0; i < this.context.numIterations; ++i) {
            if (this.cancelled) {
                return;
            }
            timestep = (long)((double)timestep * (1.0 - (double)i / (double)this.context.numIterations));
            long step = timestep + 50L;
            m_fsim.runSimulator(step);
        }
        part.resetNodes();
        for (LayoutNode ln : part.getNodeList()) {
            if (this.cancelled) {
                return;
            }
            if (ln.isLocked()) continue;
            ForceItem fitem = (ForceItem)forceItems.get(ln);
            ln.setX((double)fitem.location[0]);
            ln.setY((double)fitem.location[1]);
            part.moveNodeToLocation(ln);
        }
    }

    public void cancel() {
        super.cancel();
        this.monitor.cancel();
    }

    protected float getMassValue(LayoutNode n) {
        return (float)this.context.defaultNodeMass;
    }

    protected float getSpringLength(LayoutEdge e) {
        double weight = e.getWeight();
        if (weight == 0.0) {
            return (float)this.context.defaultSpringLength;
        }
        return (float)(this.context.defaultSpringLength / weight);
    }

    protected float getSpringCoefficient(LayoutEdge e) {
        return (float)this.context.defaultSpringCoefficient;
    }
}

