/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyndex2.internal.ui.swing;

import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Timestamp;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.cytoscape.cyndex2.internal.CyServiceModule;
import org.cytoscape.cyndex2.internal.util.NDExNetworkManager;
import org.cytoscape.cyndex2.internal.util.Server;
import org.cytoscape.cyndex2.internal.util.UpdateUtil;
import org.cytoscape.cyndex2.internal.util.UserAgentUtil;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.util.swing.IconManager;
import org.ndexbio.model.object.network.NetworkSummary;
import org.ndexbio.rest.client.NdexRestClient;
import org.ndexbio.rest.client.NdexRestClientModelAccessLayer;

public class UpdateSettingsDialog
extends JDialog {
    final int ICON_FONT_SIZE = 44;
    private final CyNetwork network;
    private final boolean noInitialUUID;
    private UUID newUUID = null;
    private boolean changed = false;
    private Server selectedServer;
    private JButton cancel;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JButton okButton;
    private JTextField uuidTextField;

    public boolean isChanged() {
        return this.changed;
    }

    public UUID getNewUUID() {
        return this.newUUID;
    }

    public UpdateSettingsDialog(JDialog parent, CyNetwork network, Server selectedServer, boolean noInitialUUID) {
        super((Dialog)parent, true);
        this.network = network;
        this.selectedServer = selectedServer;
        this.noInitialUUID = noInitialUUID;
        this.initComponents();
    }

    private String getExistingUUID() {
        UUID uuid = this.network == null ? null : NDExNetworkManager.getUUID(this.network);
        String uuidString = uuid == null ? "" : uuid.toString();
        return uuidString;
    }

    private void initComponents() {
        this.uuidTextField = this.initializeUUIDField();
        this.jLabel4 = new JLabel();
        this.okButton = new JButton();
        this.cancel = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Update Network Settings");
        this.setIconImage(null);
        this.uuidTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateSettingsDialog.this.uuidTextFieldActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Network UUID");
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateSettingsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateSettingsDialog.this.cancelActionPerformed(evt);
            }
        });
        this.jLabel1.setFont(new Font("Dialog", 2, 12));
        this.jLabel1.setText("<html><body>You are about to update the remote network specified by the UUID below. This process is not reversible.</body></html>");
        this.jLabel3.setFont(CyServiceModule.getService(IconManager.class).getIconFont(35.0f));
        this.jLabel3.setText("\uf071");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(230, Short.MAX_VALUE).addComponent(this.cancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton)).addGroup(layout.createSequentialGroup().addGap(43, 43, 43).addComponent(this.jLabel3, -2, 47, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1, -2, 259, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.uuidTextField))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1, -2, 41, -2).addComponent(this.jLabel3, -2, 43, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.uuidTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancel)).addContainerGap()));
        this.pack();
    }

    private JTextField initializeUUIDField() {
        JTextField uuidTextField = new JTextField();
        uuidTextField.setText(this.noInitialUUID ? "" : this.getExistingUUID());
        uuidTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                UpdateSettingsDialog.this.changed = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                UpdateSettingsDialog.this.changed = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                UpdateSettingsDialog.this.changed = true;
            }
        });
        return uuidTextField;
    }

    private void uuidTextFieldActionPerformed(ActionEvent evt) {
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.applySettings();
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.changed = false;
        this.setVisible(false);
    }

    private void applySettings() {
        Timestamp serverTimestamp;
        UUID verifiedUUID;
        if (!this.changed || this.noInitialUUID && this.uuidTextField.getText().trim().length() == 0) {
            System.out.println("Nothing changed. Leaving old UUID");
            this.setVisible(false);
            return;
        }
        System.out.println("UUID changed. Verifying.");
        try {
            String uuidString = this.uuidTextField.getText().trim();
            UUID potentialUUID = UUID.fromString(uuidString);
            NdexRestClient nc = new NdexRestClient(this.selectedServer.getUsername(), this.selectedServer.getPassword(), this.selectedServer.getUrl(), UserAgentUtil.getUserAgent());
            NdexRestClientModelAccessLayer mal = new NdexRestClientModelAccessLayer(nc);
            verifiedUUID = UpdateUtil.updateIsPossible(this.network, potentialUUID, nc, mal, false);
            NetworkSummary ns = mal.getNetworkSummaryById(verifiedUUID);
            serverTimestamp = ns.getModificationTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "<html><body>Error validating UUID: <br>" + e.getMessage() + "</html></body>", "Invalid UUID", 2);
            verifiedUUID = null;
            serverTimestamp = null;
        }
        if (verifiedUUID != null && serverTimestamp != null) {
            NDExNetworkManager.saveUUID(this.network, verifiedUUID, serverTimestamp);
            this.newUUID = verifiedUUID;
            this.setVisible(false);
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(UpdateSettingsDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(UpdateSettingsDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(UpdateSettingsDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(UpdateSettingsDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                UpdateSettingsDialog dialog = new UpdateSettingsDialog(new JDialog(), null, null, true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

