/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyndex2.internal.ui.swing;

import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import org.cytoscape.cyndex2.internal.ui.swing.ProfilePopupMenu;
import org.cytoscape.cyndex2.internal.util.IconUtil;
import org.cytoscape.cyndex2.internal.util.Server;
import org.cytoscape.cyndex2.internal.util.ServerManager;
import org.cytoscape.cyndex2.internal.util.ServerUtil;
import org.cytoscape.util.swing.TextIcon;

public class SignInButtonHelper {
    public static JButton createSignInButton(JDialog frame) {
        final ProfilePopupMenu popup = new ProfilePopupMenu(frame);
        Font font = IconUtil.getAppFont(23.0f);
        int iconSize = 24;
        TextIcon icon = new TextIcon("\ue900", font, iconSize, iconSize);
        JButton signInButton = new JButton();
        signInButton.setIcon((Icon)icon);
        signInButton.setText(SignInButtonHelper.getSignInText());
        signInButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        return signInButton;
    }

    public static String getSignInText() {
        Server selectedServer = ServerManager.INSTANCE.getSelectedServer();
        if (selectedServer == null) {
            return "Sign in";
        }
        return "<html>" + ServerUtil.getDisplayUsernameHTML(selectedServer.getUsername()) + "@" + selectedServer.getUrl() + " &#9662;</html>";
    }
}

