/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyndex2.internal.ui.swing;

import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.cytoscape.cyndex2.internal.util.ServerManager;
import org.cytoscape.cyndex2.internal.util.UserAgentUtil;
import org.ndexbio.model.object.NdexStatus;
import org.ndexbio.rest.client.NdexRestClient;
import org.ndexbio.rest.client.NdexRestClientModelAccessLayer;

public class SignInAdvancedDialog
extends JDialog {
    final int ICON_FONT_SIZE = 44;
    private String serverURL = null;
    private boolean changed = false;
    private JButton cancel;
    private JLabel instructionText;
    private JButton okButton;
    private JLabel serverURLLabel;
    private JTextField serverURLTextField;

    public boolean isChanged() {
        return this.changed;
    }

    public String getNewServerURL() {
        return this.serverURL;
    }

    public SignInAdvancedDialog(JDialog parent, String serverURL) {
        super((Dialog)parent, true);
        this.serverURL = serverURL;
        this.initComponents();
    }

    private void initComponents() {
        this.serverURLTextField = this.createServerURLField();
        this.serverURLLabel = new JLabel();
        this.okButton = new JButton();
        this.cancel = new JButton();
        this.instructionText = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("NDEx Server Settings");
        this.setIconImage(null);
        this.serverURLTextField.setText(this.serverURL);
        this.serverURLTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignInAdvancedDialog.this.serverURLTextFieldActionPerformed(evt);
            }
        });
        this.serverURLLabel.setText("Server URL:");
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignInAdvancedDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignInAdvancedDialog.this.cancelActionPerformed(evt);
            }
        });
        this.instructionText.setFont(new Font("Dialog", 2, 12));
        this.instructionText.setHorizontalAlignment(0);
        this.instructionText.setText("<html><body>Enter a valid NDEx server URL.</body></html>");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 231, Short.MAX_VALUE).addComponent(this.cancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton)).addGroup(layout.createSequentialGroup().addComponent(this.serverURLLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.serverURLTextField)).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.instructionText, -2, 259, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.instructionText, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.serverURLLabel).addComponent(this.serverURLTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancel)).addContainerGap()));
        this.pack();
    }

    private JTextField createServerURLField() {
        JTextField serverURLTextField = new JTextField();
        serverURLTextField.setText(this.serverURL);
        serverURLTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SignInAdvancedDialog.this.changed = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SignInAdvancedDialog.this.changed = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SignInAdvancedDialog.this.changed = true;
            }
        });
        return serverURLTextField;
    }

    private void serverURLTextFieldActionPerformed(ActionEvent evt) {
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.applySettings();
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.changed = false;
        this.setVisible(false);
    }

    private void applySettings() {
        String verifiedURL;
        if (!this.changed || this.serverURLTextField.getText().trim().length() == 0) {
            System.out.println("Nothing changed. Leaving old server URL");
            this.setVisible(false);
            return;
        }
        System.out.println("Server URL changed. Verifying.");
        try {
            String trimmedURL = this.serverURLTextField.getText().trim();
            String baseRoute = ServerManager.getBaseRoute(trimmedURL);
            NdexRestClient nc = new NdexRestClient(baseRoute);
            nc.setAdditionalUserAgent(UserAgentUtil.getUserAgent());
            NdexRestClientModelAccessLayer mal = new NdexRestClientModelAccessLayer(nc);
            NdexStatus status = mal.getServerStatus();
            verifiedURL = status.getProperties().size() > 0 ? trimmedURL : null;
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "<html><body>Error validating NDEx Server URL: <br>" + e.getMessage() + "</html></body>", "Invalid URL", 2);
            verifiedURL = null;
        }
        if (verifiedURL != null) {
            this.serverURL = verifiedURL;
            this.setVisible(false);
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(SignInAdvancedDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(SignInAdvancedDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(SignInAdvancedDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(SignInAdvancedDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SignInAdvancedDialog dialog = new SignInAdvancedDialog(new JDialog(), "public.ndexbio.org");
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

