/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyndex2.internal.ui.swing;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.cytoscape.cyndex2.internal.ui.swing.SignInDialog;
import org.cytoscape.cyndex2.internal.util.IconUtil;
import org.cytoscape.cyndex2.internal.util.Server;
import org.cytoscape.cyndex2.internal.util.ServerKey;
import org.cytoscape.cyndex2.internal.util.ServerList;
import org.cytoscape.cyndex2.internal.util.ServerManager;
import org.cytoscape.cyndex2.internal.util.ServerUtil;
import org.cytoscape.util.swing.TextIcon;

public class ProfilePopupMenu
extends JPopupMenu {
    static final Font font = IconUtil.getAppFont(23.0f);
    static int iconSize = 24;
    static final Icon ADD_PROFILE_ICON = new TextIcon("\ue902", font, iconSize, iconSize);
    static final Icon REMOVE_PROFILE_ICON = new TextIcon("\ue901", font, iconSize, iconSize);
    static final Icon PROFILE_ICON = new TextIcon("\ue900", font, iconSize, iconSize);
    final JDialog parent;

    public ProfilePopupMenu(JDialog frame) {
        this.parent = frame;
    }

    @Override
    public void show(Component invoker, int x, int y) {
        List serverItems;
        while (this.getSubElements().length > 0) {
            this.remove(0);
        }
        ServerList serverList = ServerManager.INSTANCE.getAvailableServers();
        final Server selectedServer = ServerManager.INSTANCE.getSelectedServer();
        if (selectedServer != null) {
            if (selectedServer.getUsername() != null) {
                this.add(new JMenuItem(new AbstractAction(" Log out of Current Profile"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ServerKey key = new ServerKey(null, selectedServer.getUrl());
                        Server anonymousConn = ServerManager.INSTANCE.getAvailableServers().getServer(key);
                        if (anonymousConn != null) {
                            ServerManager.INSTANCE.setSelectedServer(key);
                        } else {
                            try {
                                ServerManager.INSTANCE.addServer(null, null, selectedServer.getUrl());
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                }));
                this.addSeparator();
            }
            this.add(new JMenuItem(new AbstractAction("Remove Current Profile", REMOVE_PROFILE_ICON){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("log out " + selectedServer.getUsername() + "@" + selectedServer.getUrl());
                    ServerManager.INSTANCE.removeServer(selectedServer);
                }
            }));
            this.addSeparator();
        }
        if ((serverItems = serverList.stream().filter(server2 -> !server2.equals(selectedServer)).collect(Collectors.toList())).size() > 0) {
            serverItems.stream().forEach(server -> {
                JMenuItem jMenuItem = new JMenuItem(new AbstractAction("<HTML><b>" + ServerUtil.getDisplayUsernameHTML(server.getUsername()) + "</b>" + "<br>" + server.getUrl() + "</HTML>", PROFILE_ICON, (Server)server){
                    private final /* synthetic */ Server val$server;
                    {
                        this.val$server = server;
                        super($anonymous0, $anonymous1);
                    }

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        ServerManager.INSTANCE.setSelectedServer(new ServerKey(this.val$server));
                    }
                });
                this.add(jMenuItem);
            });
            this.addSeparator();
        }
        this.add(new JMenuItem(new AbstractAction("Add new profile...", ADD_PROFILE_ICON){

            @Override
            public void actionPerformed(ActionEvent e) {
                SignInDialog signInDialog = new SignInDialog(ProfilePopupMenu.this.parent);
                signInDialog.setLocationRelativeTo(ProfilePopupMenu.this.parent);
                signInDialog.setVisible(true);
            }
        }));
        super.show(invoker, x, y);
    }
}

