/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyndex2.internal.ui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.cytoscape.cyndex2.internal.CyServiceModule;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.TextIcon;
import org.ndexbio.model.object.network.NetworkSummary;
import org.ndexbio.model.object.network.VisibilityType;

public class NetworkSummaryTableModel
extends AbstractTableModel {
    public static final int IMPORT_COL = 0;
    public static final int NAME_COL = 1;
    public static final int OWNER_COL = 2;
    public static final int VISIBILITY_COL = 3;
    public static final int NODES_COL = 4;
    public static final int EDGES_COL = 5;
    public static final int MODIFIED_COL = 6;
    private final List<NetworkSummary> networkSummaries;
    private Consumer<NetworkSummary> networkSummaryConsumer;

    public NetworkSummaryTableModel(List<NetworkSummary> networkSummaries, Consumer<NetworkSummary> networkSummaryConsumer) {
        this.networkSummaries = new ArrayList<NetworkSummary>(networkSummaries);
        this.networkSummaryConsumer = networkSummaryConsumer;
    }

    private static TextIcon getImportIcon() {
        IconManager iconManager = CyServiceModule.getService(IconManager.class);
        TextIcon importIcon = new TextIcon("\uf01a", iconManager.getIconFont(24.0f), new Color(28, 140, 46), 24, 24);
        return importIcon;
    }

    private void load(NetworkSummary networkSummary) {
        this.networkSummaryConsumer.accept(networkSummary);
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public int getRowCount() {
        return this.networkSummaries.size();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return NetworkSummary.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return VisibilityType.class;
            }
            case 4: {
                return Integer.class;
            }
            case 5: {
                return Integer.class;
            }
            case 6: {
                return Timestamp.class;
            }
        }
        throw new IllegalArgumentException("Column at index " + columnIndex + " does not exist.");
    }

    @Override
    public Object getValueAt(int arg0, int arg1) {
        NetworkSummary networkSummary = this.networkSummaries.get(arg0);
        switch (arg1) {
            case 0: {
                return networkSummary;
            }
            case 1: {
                return networkSummary.getName();
            }
            case 2: {
                return networkSummary.getOwner();
            }
            case 3: {
                return networkSummary.getVisibility();
            }
            case 4: {
                return networkSummary.getNodeCount();
            }
            case 5: {
                return networkSummary.getEdgeCount();
            }
            case 6: {
                return networkSummary.getModificationTime();
            }
        }
        throw new IllegalArgumentException("Column at index " + arg1 + " does not exist.");
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "";
            }
            case 1: {
                return "name";
            }
            case 2: {
                return "owner";
            }
            case 3: {
                return "visibility";
            }
            case 4: {
                return "nodes";
            }
            case 5: {
                return "edges";
            }
            case 6: {
                return "modified";
            }
        }
        throw new IllegalArgumentException("Column at index " + columnIndex + " does not exist.");
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 0;
    }

    public class ImportButtonEditor
    extends DefaultCellEditor {
        protected JButton button;
        private NetworkSummary networkSummary;
        private boolean isPushed;

        public ImportButtonEditor(JCheckBox checkBox) {
            super(checkBox);
            this.button = new JButton("Import");
            this.button.setOpaque(true);
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NetworkSummaryTableModel.this.load(ImportButtonEditor.this.networkSummary);
                    ImportButtonEditor.this.fireEditingStopped();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (isSelected) {
                this.button.setForeground(table.getSelectionForeground());
                this.button.setBackground(table.getSelectionBackground());
            } else {
                this.button.setForeground(table.getForeground());
                this.button.setBackground(table.getBackground());
            }
            this.networkSummary = (NetworkSummary)value;
            this.button.setText("Importing");
            this.isPushed = true;
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            this.isPushed = false;
            return this.networkSummary;
        }

        @Override
        public boolean stopCellEditing() {
            this.isPushed = false;
            return super.stopCellEditing();
        }
    }

    public static class ImportButtonRenderer
    implements TableCellRenderer {
        JButton button = new JButton((Icon)NetworkSummaryTableModel.getImportIcon());

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.button.setBorder(BorderFactory.createEmptyBorder());
            this.button.setBorderPainted(false);
            this.button.setContentAreaFilled(false);
            this.button.setToolTipText("Import network to Cytoscape");
            return this.button;
        }
    }

    public static class TimestampRenderer
    extends DefaultTableCellRenderer {
        DateFormat formatter;

        @Override
        public void setValue(Object value) {
            if (this.formatter == null) {
                this.formatter = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
            }
            this.setText(value == null && value instanceof Timestamp ? "" : this.formatter.format((Timestamp)value));
        }
    }

    public static class VisibilityTypeRenderer
    extends DefaultTableCellRenderer {
        @Override
        public void setValue(Object value) {
            this.setText(value == null && value instanceof VisibilityType ? "" : ((VisibilityType)value).name());
        }
    }
}

