/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyndex2.internal.ui.swing;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URI;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.TableCellRenderer;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.cytoscape.cyndex2.internal.CyActivator;
import org.cytoscape.cyndex2.internal.CyServiceModule;
import org.cytoscape.cyndex2.internal.rest.parameter.LoadParameters;
import org.cytoscape.cyndex2.internal.rest.parameter.NDExImportParameters;
import org.cytoscape.cyndex2.internal.ui.swing.LargeNetworkDialog;
import org.cytoscape.cyndex2.internal.ui.swing.ModalProgressHelper;
import org.cytoscape.cyndex2.internal.ui.swing.NetworkSummaryTableModel;
import org.cytoscape.cyndex2.internal.ui.swing.SignInButtonHelper;
import org.cytoscape.cyndex2.internal.util.CxPreferences;
import org.cytoscape.cyndex2.internal.util.IconUtil;
import org.cytoscape.cyndex2.internal.util.Server;
import org.cytoscape.cyndex2.internal.util.ServerManager;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.TextIcon;
import org.ndexbio.model.exceptions.NdexException;
import org.ndexbio.model.object.network.NetworkSummary;
import org.ndexbio.model.object.network.VisibilityType;
import org.ndexbio.rest.client.NdexRestClientModelAccessLayer;

public class FindNetworksDialog
extends JDialog
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private List<NetworkSummary> networkSummaries;
    static final Font font = IconUtil.getAppFont(32.0f);
    static final int ICON_SIZE = 32;
    static final Icon NDEX_ICON = new TextIcon("\ue906", font, IconUtil.ICON_COLOR_1, 32, 32);
    final LoadParameters loadParameters;
    private static FindNetworksDialog loadDialog = null;
    private List<NetworkSummary> displayedNetworkSummaries = new ArrayList<NetworkSummary>();
    private JCheckBox administeredByMe;
    private JButton done;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel ndexLogo;
    private JTable resultsTable;
    private JButton search;
    private JTextField searchField;

    public FindNetworksDialog(Frame parent, LoadParameters loadParameters) {
        super(parent, false);
        ServerManager.INSTANCE.addPropertyChangeListener(this);
        this.loadParameters = loadParameters;
        this.initComponents();
        this.prepComponents();
    }

    public static void getFindNetworksDialog(LoadParameters loadParameters) {
        if (loadDialog != null && loadDialog.isVisible()) {
            loadDialog.setVisible(false);
        }
        loadDialog = new FindNetworksDialog(null, loadParameters);
        JFrame parentFrame = CyServiceModule.INSTANCE.getSwingApplication().getJFrame();
        loadDialog.setLocationRelativeTo(parentFrame);
        loadDialog.setVisible(true);
    }

    private TextIcon getSearchIcon() {
        IconManager iconManager = CyServiceModule.getService(IconManager.class);
        TextIcon searchIcon = new TextIcon("\uf002", iconManager.getIconFont(24.0f), 24, 24);
        return searchIcon;
    }

    private void setSearchEnabled(boolean enabled) {
        String tooltip = enabled ? "Search NDEx for networks by text" : "To enable searching, make sure the 'My Networks' checkbox is unselected.";
        this.searchField.setEnabled(enabled);
        this.searchField.setToolTipText(tooltip);
        this.search.setEnabled(enabled);
        this.search.setToolTipText(tooltip);
    }

    private void load(NetworkSummary networkSummary) {
        boolean createView;
        boolean importNetwork;
        long viewThreshold;
        long networkSize = networkSummary.getNodeCount() + networkSummary.getEdgeCount();
        if (networkSize > (viewThreshold = (long)CxPreferences.getViewThreshold())) {
            LargeNetworkDialog viewCreationDialog = new LargeNetworkDialog((Dialog)this, true, networkSummary);
            viewCreationDialog.setLocationRelativeTo(this);
            viewCreationDialog.setVisible(true);
            importNetwork = viewCreationDialog.getImportNetwork();
            createView = viewCreationDialog.getCreateView();
        } else {
            importNetwork = true;
            createView = true;
        }
        if (importNetwork) {
            ModalProgressHelper.runWorker(this, "Loading Network", () -> {
                boolean success;
                Server selectedServer = ServerManager.INSTANCE.getServer();
                try {
                    NdexRestClientModelAccessLayer mal = selectedServer.getModelAccessLayer();
                    success = selectedServer.check(mal);
                }
                catch (IOException | NdexException e1) {
                    e1.printStackTrace();
                    success = false;
                }
                if (success) {
                    UUID uuid = networkSummary.getExternalId();
                    try {
                        String REST_URI = "http://localhost:" + CyActivator.getCyRESTPort() + "/cyndex2/v1/networks";
                        CloseableHttpClient httpClient = HttpClients.createDefault();
                        URI uri = URI.create(REST_URI);
                        HttpPost post = new HttpPost(uri.toString());
                        post.setHeader("Content-type", "application/json");
                        NDExImportParameters importParameters = new NDExImportParameters(uuid.toString(), selectedServer.getUsername(), selectedServer.getPassword(), selectedServer.getUrl(), null, null, createView);
                        ObjectMapper objectMapper = new ObjectMapper();
                        post.setEntity((HttpEntity)new StringEntity(objectMapper.writeValueAsString((Object)importParameters)));
                        httpClient.execute((HttpUriRequest)post);
                    }
                    catch (RuntimeException ex2) {
                        JOptionPane.showMessageDialog(null, "This network can't be imported to cytoscape. Cause: " + ex2.getMessage(), "Error", 0);
                        ex2.printStackTrace();
                        return -1;
                    }
                    catch (ClientProtocolException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "Failed to communicate with server. Please check your server settings before continuing.", "Error", 0);
                    return -1;
                }
                return 1;
            });
        }
    }

    public void setFocusOnDone() {
        this.getRootPane().setDefaultButton(this.done);
        this.done.requestFocus();
    }

    private void prepComponents() {
        block14: {
            NdexRestClientModelAccessLayer mal;
            this.getRootPane().setDefaultButton(this.search);
            this.searchField.setText(this.loadParameters.searchTerm);
            this.setSearchEnabled(!this.loadParameters.userNetworksOnly);
            Server selectedServer = ServerManager.INSTANCE.getServer();
            try {
                mal = selectedServer.getModelAccessLayer();
            }
            catch (IOException | NdexException e) {
                mal = null;
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Failed to communicate with server. Please check your server settings before continuing.\n\nError Message: " + e.getMessage(), "Error", 0);
            }
            if (selectedServer.getUsername() != null && !selectedServer.getUsername().isEmpty()) {
                this.administeredByMe.setVisible(true);
            } else if (selectedServer.getUsername() != null) {
                try {
                    selectedServer.check(mal);
                    this.administeredByMe.setVisible(true);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, "Failed to communicate with server. Please check your server settings before continuing.\n\nError Message: " + e.getMessage(), "Error", 0);
                }
            } else {
                this.administeredByMe.setVisible(false);
            }
            try {
                if (selectedServer.check(mal)) {
                    try {
                        if (this.loadParameters.userNetworksOnly) {
                            this.networkSummaries = mal != null ? mal.getMyNetworks() : List.of();
                            break block14;
                        }
                        this.networkSummaries = mal != null ? mal.findNetworks(this.loadParameters.searchTerm, null, null, true, 0, 400).getNetworks() : List.of();
                    }
                    catch (IOException | NdexException ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(this, "Failed to communicate with server. Please check your server settings before continuing.\n\nError Message: " + ex.getMessage(), "Error", 0);
                        this.networkSummaries = List.of();
                    }
                    break block14;
                }
                JOptionPane.showMessageDialog(this, "Failed to communicate with server. Please check your server settings before continuing.", "Error", 0);
                this.networkSummaries = List.of();
            }
            catch (HeadlessException | IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Failed to communicate with server. Please check your server settings before continuing.\n\nError Message: " + e.getMessage(), "Error", 0);
                this.networkSummaries = List.of();
            }
        }
        this.showSearchResults();
    }

    private JTable getResultsTable() {
        return new JTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                JComponent jcomp;
                Component comp = super.prepareRenderer(renderer, row, col);
                if (comp == (jcomp = (JComponent)comp) && col != 0 && row < super.getRowCount() && super.getColumnCount() > 0) {
                    try {
                        NetworkSummary networkSummary = (NetworkSummary)this.getValueAt(row, 0);
                        String toolTip = networkSummary.getDescription() == null ? null : "<html>" + networkSummary.getDescription() + "</html>";
                        jcomp.setToolTipText(toolTip);
                    }
                    catch (Exception e) {
                        System.out.println("Ignored table renderer error while making tool tip");
                    }
                }
                return comp;
            }
        };
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.resultsTable = this.getResultsTable();
        this.done = new JButton();
        this.search = new JButton((Icon)this.getSearchIcon());
        this.searchField = new JTextField();
        this.administeredByMe = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jButton1 = SignInButtonHelper.createSignInButton(this);
        this.ndexLogo = new JLabel("NDEx", NDEX_ICON, 2);
        this.setDefaultCloseOperation(2);
        this.setTitle("Find Networks");
        this.jScrollPane2.setBorder(null);
        this.resultsTable.setAutoCreateRowSorter(true);
        this.resultsTable.setIntercellSpacing(new Dimension(6, 2));
        this.resultsTable.setRowHeight(24);
        this.resultsTable.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.resultsTable);
        this.done.setText("Close Dialog");
        this.done.setToolTipText("Click to close this dialog when done downloading");
        this.done.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindNetworksDialog.this.doneActionPerformed(evt);
            }
        });
        this.search.setMargin(new Insets(2, 2, 2, 2));
        this.search.setEnabled(!this.loadParameters.userNetworksOnly);
        this.search.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindNetworksDialog.this.searchActionPerformed(evt);
            }
        });
        this.searchField.setEnabled(!this.loadParameters.userNetworksOnly);
        this.administeredByMe.setFont(new Font("Tahoma", 0, 14));
        this.administeredByMe.setText("My Networks");
        this.administeredByMe.setToolTipText("Enable this to view the networks in your account");
        this.administeredByMe.setSelected(this.loadParameters.userNetworksOnly);
        this.administeredByMe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindNetworksDialog.this.administeredByMeActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Results");
        this.jLabel4.setText("WARNING: In some cases, not all network information stored in NDEx will be available within Cytoscape after loading.");
        this.jButton1.setText(SignInButtonHelper.getSignInText());
        this.jButton1.setHorizontalAlignment(4);
        this.jButton1.setMaximumSize(new Dimension(200, 30));
        this.jButton1.setMinimumSize(new Dimension(48, 30));
        this.ndexLogo.setFont(new Font("Ubuntu", 0, 24));
        this.ndexLogo.setText("NDEx");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jLabel4).addContainerGap(-1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 856, Short.MAX_VALUE)).addComponent(this.jScrollPane1).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.searchField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.search, -2, 40, -2)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.ndexLogo, -2, 170, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton1, -2, -1, -2)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.done, -2, 183, -2))).addContainerGap()))).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.administeredByMe).addGap(398, 398, 398)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButton1, -2, -1, -2).addComponent(this.ndexLogo)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.search, -1, -1, Short.MAX_VALUE).addComponent(this.searchField)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.administeredByMe).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 287, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.done).addContainerGap()));
        this.jScrollPane2.setViewportView(this.jPanel1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2).addContainerGap()));
        this.pack();
    }

    private void getMyNetworks() {
        block5: {
            Server selectedServer = ServerManager.INSTANCE.getSelectedServer();
            try {
                NdexRestClientModelAccessLayer mal = selectedServer.getModelAccessLayer();
                if (selectedServer.check(mal)) {
                    try {
                        this.networkSummaries = mal.getMyNetworks();
                        this.showSearchResults();
                        break block5;
                    }
                    catch (IOException | NdexException ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
                        return;
                    }
                }
                JOptionPane.showMessageDialog(this, "Failed to communicate with server. Please check your server settings before continuing.", "ErrorY", 0);
            }
            catch (HeadlessException | IOException | NdexException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Failed to communicate with server. Please check your server settings before continuing.", "ErrorY", 0);
            }
        }
    }

    private void doneActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void search() {
        block6: {
            Server selectedServer = ServerManager.INSTANCE.getServer();
            String searchText = this.searchField.getText();
            if (searchText.isEmpty()) {
                searchText = "";
            }
            try {
                NdexRestClientModelAccessLayer mal = selectedServer.getModelAccessLayer();
                if (selectedServer.check(mal)) {
                    try {
                        this.networkSummaries = this.administeredByMe.isSelected() ? mal.getMyNetworks() : mal.findNetworks(searchText, null, null, true, 0, 10000).getNetworks();
                    }
                    catch (IOException | NdexException ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
                        return;
                    }
                    this.showSearchResults();
                    break block6;
                }
                JOptionPane.showMessageDialog(this, "Failed to communicate with server. Please check your server settings before continuing.", "ErrorY", 0);
            }
            catch (HeadlessException | IOException | NdexException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Failed to communicate with server. Please check your server settings before continuing.", "ErrorY", 0);
            }
        }
    }

    private void searchActionPerformed(ActionEvent evt) {
        ModalProgressHelper.runWorker(this, "Searching", () -> {
            this.search();
            return 1;
        });
    }

    private void administeredByMeActionPerformed(ActionEvent evt) {
        ModalProgressHelper.runWorker(this, "Updating Networks", () -> {
            if (this.administeredByMe.isSelected()) {
                this.getMyNetworks();
            } else {
                this.search();
            }
            this.setSearchEnabled(!this.administeredByMe.isSelected());
            return 1;
        });
    }

    private void showSearchResults() {
        NetworkSummaryTableModel model = new NetworkSummaryTableModel(this.networkSummaries, this::load);
        this.displayedNetworkSummaries.clear();
        for (NetworkSummary networkSummary : this.networkSummaries) {
            this.displayedNetworkSummaries.add(networkSummary);
        }
        this.resultsTable.setModel(model);
        this.resultsTable.getColumnModel().getColumn(0).setPreferredWidth(24);
        this.resultsTable.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.resultsTable.getColumnModel().getColumn(3).setPreferredWidth(20);
        this.resultsTable.getColumnModel().getColumn(2).setPreferredWidth(40);
        this.resultsTable.getColumnModel().getColumn(4).setPreferredWidth(20);
        this.resultsTable.getColumnModel().getColumn(5).setPreferredWidth(20);
        this.resultsTable.setDefaultRenderer(NetworkSummary.class, new NetworkSummaryTableModel.ImportButtonRenderer());
        this.resultsTable.setDefaultRenderer(VisibilityType.class, new NetworkSummaryTableModel.VisibilityTypeRenderer());
        this.resultsTable.setDefaultRenderer(Timestamp.class, new NetworkSummaryTableModel.TimestampRenderer());
        this.resultsTable.setShowGrid(false);
        NetworkSummaryTableModel networkSummaryTableModel = model;
        networkSummaryTableModel.getClass();
        this.resultsTable.setDefaultEditor(NetworkSummary.class, new NetworkSummaryTableModel.ImportButtonEditor(networkSummaryTableModel, new JCheckBox()));
        this.resultsTable.getSelectionModel().setSelectionInterval(0, 0);
        this.resultsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    FindNetworksDialog.this.load(FindNetworksDialog.this.networkSummaries.get(FindNetworksDialog.this.resultsTable.getSelectedRow()));
                }
            }
        });
        this.resultsTable.getTableHeader().setPreferredSize(new Dimension(this.resultsTable.getPreferredSize().width, 24));
    }

    public static void main(String[] args) {
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FindNetworksDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FindNetworksDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FindNetworksDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FindNetworksDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FindNetworksDialog dialog = new FindNetworksDialog((Frame)new JFrame(), null);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        if (this.isVisible()) {
            ModalProgressHelper.runWorker(this, "Loading Profile", () -> {
                this.jButton1.setText(SignInButtonHelper.getSignInText());
                Server selectedServer = ServerManager.INSTANCE.getServer();
                if (this.administeredByMe.isSelected()) {
                    this.administeredByMe.setSelected(selectedServer.getUsername() != null && !selectedServer.getUsername().isEmpty());
                }
                this.administeredByMe.setVisible(selectedServer.getUsername() != null && !selectedServer.getUsername().isEmpty());
                this.setSearchEnabled(!this.administeredByMe.isVisible() || !this.administeredByMe.isSelected());
                this.search();
                return 1;
            });
        }
    }
}

