/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyndex2.internal.ui;

import java.awt.Desktop;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.cyndex2.internal.CyActivator;
import org.cytoscape.cyndex2.internal.ui.ImportNetworkFromNDExTaskFactory;
import org.cytoscape.cyndex2.internal.ui.ImportUserNetworkFromNDExTaskFactory;
import org.cytoscape.cyndex2.internal.ui.SaveNetworkToNDExTaskFactory;
import org.cytoscape.cyndex2.internal.ui.swing.SignInDialog;
import org.cytoscape.cyndex2.internal.util.IconUtil;
import org.cytoscape.cyndex2.internal.util.Server;
import org.cytoscape.cyndex2.internal.util.ServerManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.util.swing.TextIcon;
import org.cytoscape.work.swing.DialogTaskManager;

public class MainToolBarAction
extends AbstractCyAction {
    private static final String TITLE = "Open or Save Networks in NDEx...";
    private static final String DESCRIPTION = "Open or Save Networks and Collections in NDEx, the Cloud Storage for the Cytoscape Cyberinfrastructure";
    private final ImportNetworkFromNDExTaskFactory importTaskFactory;
    private final ImportUserNetworkFromNDExTaskFactory importUserNetworkTaskFactory;
    private final SaveNetworkToNDExTaskFactory saveTaskFactory;
    private final CyServiceRegistrar serviceRegistrar;

    public MainToolBarAction(ImportNetworkFromNDExTaskFactory importTaskFactory, ImportUserNetworkFromNDExTaskFactory importUserNetworkTaskFactory, SaveNetworkToNDExTaskFactory saveTaskFactory, CyServiceRegistrar serviceRegistrar) {
        super(TITLE);
        this.importTaskFactory = importTaskFactory;
        this.importUserNetworkTaskFactory = importUserNetworkTaskFactory;
        this.saveTaskFactory = saveTaskFactory;
        this.serviceRegistrar = serviceRegistrar;
        this.inToolBar = true;
        this.insertToolbarSeparatorAfter = true;
        this.toolbarGravity = -32768.0f;
        this.putValue("ShortDescription", TITLE);
        this.putValue("LongDescription", DESCRIPTION);
        this.putValue("SwingLargeIconKey", IconUtil.getNdexIcon());
    }

    public void actionPerformed(ActionEvent e) {
        JComponent comp = e.getSource() instanceof JComponent ? (JComponent)e.getSource() : ((CySwingApplication)this.serviceRegistrar.getService(CySwingApplication.class)).getJToolBar();
        this.showPopupMenu(comp);
    }

    public boolean isEnabled() {
        return this.importTaskFactory.isReady() || this.saveTaskFactory.isReady();
    }

    private JMenuItem getSignInMenuItem(Font font, int iconSize) {
        final DialogTaskManager taskManager = (DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class);
        TextIcon icon = new TextIcon("\ue900", font, iconSize, iconSize);
        JMenuItem mi = new JMenuItem(new AbstractAction("Sign In/Sign Up", (Icon)icon){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame parent = ((CySwingApplication)MainToolBarAction.this.serviceRegistrar.getService(CySwingApplication.class)).getJFrame();
                SignInDialog signInDialog = new SignInDialog(null);
                signInDialog.setLocationRelativeTo(parent);
                signInDialog.setVisible(true);
                Server selectedServer = ServerManager.INSTANCE.getServer();
                if (selectedServer.getUsername() != null && !selectedServer.getUsername().isEmpty()) {
                    taskManager.execute(MainToolBarAction.this.importUserNetworkTaskFactory.createTaskIterator());
                }
                signInDialog.dispose();
            }
        });
        return mi;
    }

    private JMenuItem getMyNetworksMenuItem(Font font, int iconSize) {
        final DialogTaskManager taskManager = (DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class);
        TextIcon icon = new TextIcon("\ue900", font, iconSize, iconSize);
        JMenuItem mi = new JMenuItem(new AbstractAction("My Networks (" + ServerManager.INSTANCE.getSelectedServer().getUsername() + ")", (Icon)icon){

            @Override
            public void actionPerformed(ActionEvent e) {
                taskManager.execute(MainToolBarAction.this.importUserNetworkTaskFactory.createTaskIterator());
            }
        });
        return mi;
    }

    private void showPopupMenu(JComponent comp) {
        JPopupMenu popupMenu = new JPopupMenu();
        DialogTaskManager taskManager = (DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class);
        Font font = IconUtil.getAppFont(23.0f);
        int iconSize = 24;
        JMenuItem mi = ServerManager.INSTANCE.getAvailableServers().getSize() == 0 ? this.getSignInMenuItem(font, iconSize) : (ServerManager.INSTANCE.getSelectedServer().getUsername() == null ? this.getSignInMenuItem(font, iconSize) : this.getMyNetworksMenuItem(font, iconSize));
        popupMenu.add(mi);
        popupMenu.addSeparator();
        TextIcon icon = new TextIcon(IconUtil.LAYERED_OPEN_ICON, font, IconUtil.LAYERED_OPEN_SAVE_COLORS, iconSize, iconSize, new Integer[]{1});
        JMenuItem mi2 = new JMenuItem("Import Network from NDEx", (Icon)icon);
        mi2.addActionListener(evt -> taskManager.execute(this.importTaskFactory.createTaskIterator()));
        mi2.setEnabled(this.importTaskFactory.isReady());
        popupMenu.add(mi2);
        icon = new TextIcon(IconUtil.LAYERED_SAVE_ICON, font, IconUtil.LAYERED_OPEN_SAVE_COLORS, iconSize, iconSize, new Integer[]{1});
        mi2 = new JMenuItem("Export Network to NDEx", (Icon)icon);
        mi2.addActionListener(evt -> taskManager.execute(this.saveTaskFactory.createTaskIterator()));
        mi2.setEnabled(this.saveTaskFactory.isReady());
        popupMenu.add(mi2);
        popupMenu.addSeparator();
        mi = new JMenuItem("CyNDEx-2 Version " + CyActivator.getAppVersion());
        mi.setEnabled(false);
        popupMenu.add(mi);
        popupMenu.addSeparator();
        icon = new TextIcon("\ue906", font, iconSize, iconSize);
        mi2 = new JMenuItem(new AbstractAction("NDEx Homepage", (Icon)icon){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI("https://www.ndexbio.org"));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                catch (URISyntaxException e1) {
                    e1.printStackTrace();
                }
            }
        });
        popupMenu.add(mi2);
        icon = new TextIcon("\ue906", font, iconSize, iconSize);
        mi2 = new JMenuItem(new AbstractAction("NDEx FAQ", (Icon)icon){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI("https://home.ndexbio.org/faq/"));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                catch (URISyntaxException e1) {
                    e1.printStackTrace();
                }
            }
        });
        popupMenu.add(mi2);
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{popupMenu});
        popupMenu.show(comp, 0, comp.getSize().height);
    }
}

