/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyndex2.internal.task;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.Frame;
import java.io.IOException;
import java.net.URI;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.cytoscape.cyndex2.external.SaveParameters;
import org.cytoscape.cyndex2.internal.CyActivator;
import org.cytoscape.cyndex2.internal.CyServiceModule;
import org.cytoscape.cyndex2.internal.rest.parameter.LoadParameters;
import org.cytoscape.cyndex2.internal.ui.swing.ExportNetworkDialog;
import org.cytoscape.cyndex2.internal.ui.swing.FindNetworksDialog;
import org.cytoscape.cyndex2.internal.util.ExternalAppManager;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.AbstractTaskFactory;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;

public class OpenDialogTaskFactory
extends AbstractTaskFactory {
    protected final String appName;

    public OpenDialogTaskFactory(String appName) {
        this.appName = appName;
    }

    public TaskIterator createTaskIterator() {
        TaskIterator ti = new TaskIterator(new Task[0]);
        ExternalAppManager.appName = this.appName;
        System.out.println("open dialog for: " + this.appName);
        ti.append((Task)new AbstractTask(){

            public void run(TaskMonitor taskMonitorParameter) throws Exception {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String REST_URI = "http://localhost:" + CyActivator.getCyRESTPort() + "/cyndex2/v1/status";
                        CloseableHttpClient httpClient = HttpClients.createDefault();
                        URI uri = URI.create(REST_URI);
                        HttpGet get = new HttpGet(uri.toString());
                        get.setHeader("Content-type", "application/json");
                        try {
                            String widget;
                            HttpResponse response = httpClient.execute((HttpUriRequest)get);
                            HttpEntity entity = response.getEntity();
                            String result = EntityUtils.toString((HttpEntity)entity);
                            ObjectMapper objectMapper = new ObjectMapper();
                            JsonNode jsonNode = (JsonNode)objectMapper.readValue(result, JsonNode.class);
                            switch (widget = jsonNode.get("data").get("widget").asText()) {
                                case "choose": {
                                    LoadParameters loadParameters = (LoadParameters)objectMapper.treeToValue((TreeNode)jsonNode.get("data").get("parameters"), LoadParameters.class);
                                    FindNetworksDialog.getFindNetworksDialog(loadParameters);
                                    break;
                                }
                                case "save": {
                                    JFrame parentFrame = CyServiceModule.INSTANCE.getSwingApplication().getJFrame();
                                    SaveParameters saveParameters = (SaveParameters)objectMapper.treeToValue((TreeNode)jsonNode.get("data").get("parameters"), SaveParameters.class);
                                    ExportNetworkDialog saveDialog = new ExportNetworkDialog((Frame)parentFrame, saveParameters);
                                    saveDialog.setVisible(true);
                                    break;
                                }
                            }
                        }
                        catch (ClientProtocolException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
        return ti;
    }

    public boolean isReady() {
        return !ExternalAppManager.loadFailed();
    }
}

