/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyndex2.internal.task;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.UUID;
import javax.swing.SwingUtilities;
import org.cytoscape.cyndex2.internal.CxTaskFactoryManager;
import org.cytoscape.cyndex2.internal.CyServiceModule;
import org.cytoscape.cyndex2.internal.util.HeadlessTaskMonitor;
import org.cytoscape.cyndex2.internal.util.NDExNetworkManager;
import org.cytoscape.io.read.AbstractCyNetworkReader;
import org.cytoscape.io.read.InputStreamTaskFactory;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.ndexbio.model.exceptions.NdexException;
import org.ndexbio.model.object.network.NetworkSummary;
import org.ndexbio.rest.client.NdexRestClientModelAccessLayer;

public class NetworkImportTask
extends AbstractTask
implements ObservableTask {
    final NdexRestClientModelAccessLayer mal;
    final NetworkSummary networkSummary;
    private UUID uuid = null;
    private Long suid = null;
    private String accessKey = null;
    protected InputStream cxStream;
    private Boolean createView = null;

    public NetworkImportTask(NdexRestClientModelAccessLayer mal, UUID uuid, String accessKey, Boolean createView) throws IOException, NdexException {
        this.uuid = uuid;
        this.mal = mal;
        this.networkSummary = mal.getNetworkSummaryById(uuid, accessKey);
        this.accessKey = accessKey;
        this.cxStream = null;
        this.createView = createView;
    }

    public void run(TaskMonitor taskMonitor) throws NetworkImportException {
        try {
            CyNetwork network;
            taskMonitor.setStatusMessage("Fetching network from NDEx");
            if (this.cxStream == null) {
                UUID id = this.networkSummary.getExternalId();
                this.cxStream = this.accessKey == null ? this.mal.getNetworkAsCXStream(id) : this.mal.getNetworkAsCXStream(id, this.accessKey);
            }
            if (this.cxStream == null) {
                throw new NdexException("Unable to get network as CX stream");
            }
            taskMonitor.setProgress(0.4);
            InputStreamTaskFactory cxReaderFactory = CxTaskFactoryManager.INSTANCE.getCxReaderFactory();
            taskMonitor.setStatusMessage("Importing network with CX Reader");
            TaskIterator ti = cxReaderFactory.createTaskIterator(this.cxStream, null);
            final AbstractCyNetworkReader task = (AbstractCyNetworkReader)ti.next();
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        Class<?> cxReader = task.getClass();
                        try {
                            Method setCreateViewMethod = cxReader.getMethod("setCreateView", Boolean.class);
                            setCreateViewMethod.invoke((Object)task, NetworkImportTask.this.createView);
                        }
                        catch (NoSuchMethodException e) {
                            System.err.println("Unable to explicitly set view creation. Make sure a current version of the CX Support app is installed.");
                        }
                        task.run((TaskMonitor)new HeadlessTaskMonitor());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            if (this.cancelled) {
                return;
            }
            taskMonitor.setProgress(0.7);
            CyNetworkManager network_manager = CyServiceModule.getService(CyNetworkManager.class);
            int i = 1;
            CyNetwork[] cyNetworkArray = task.getNetworks();
            int n = cyNetworkArray.length;
            int n2 = 0;
            while (n2 < n) {
                network = cyNetworkArray[n2];
                if (this.cancelled) {
                    return;
                }
                taskMonitor.setStatusMessage(String.format("Registering network %s/%s...", i, task.getNetworks().length));
                network_manager.addNetwork(network);
                task.buildCyNetworkView(network);
                ++i;
                ++n2;
            }
            taskMonitor.setProgress(0.9);
            network = task.getNetworks()[0];
            this.suid = network.getSUID();
            if (this.networkSummary.getSubnetworkIds().size() > 0) {
                NDExNetworkManager.saveUUID((CyNetwork)((CySubNetwork)network).getRootNetwork(), this.uuid, this.networkSummary.getModificationTime());
            } else {
                NDExNetworkManager.saveUUID(network, this.uuid, this.networkSummary.getModificationTime());
            }
        }
        catch (IOException ex) {
            throw new NetworkImportException("Failed to parse JSON from NDEx source.");
        }
        catch (RuntimeException ex2) {
            ex2.printStackTrace();
            throw new NetworkImportException(ex2.getMessage());
        }
        catch (NdexException e) {
            throw new NetworkImportException("Unable to read network from NDEx: " + e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to import: " + e.getMessage());
        }
    }

    public void cancel() {
        super.cancel();
        try {
            this.cxStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public <R> R getResults(Class<? extends R> type) {
        if (this.suid == null) {
            return null;
        }
        if (type.equals(Long.class)) {
            return (R)this.suid;
        }
        return null;
    }

    public long getSUID() {
        return this.suid;
    }

    public class NetworkImportException
    extends Exception {
        private static final long serialVersionUID = -1186105413302386171L;

        public NetworkImportException(String message) {
            super(message);
        }
    }
}

