/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyndex2.internal.rest.endpoints.impl;

import javax.ws.rs.core.Response;
import org.cytoscape.ci.CIWrapping;
import org.cytoscape.cyndex2.external.SaveParameters;
import org.cytoscape.cyndex2.internal.CyServiceModule;
import org.cytoscape.cyndex2.internal.rest.endpoints.NdexStatusResource;
import org.cytoscape.cyndex2.internal.rest.errors.ErrorBuilder;
import org.cytoscape.cyndex2.internal.rest.errors.ErrorType;
import org.cytoscape.cyndex2.internal.rest.parameter.AppStatusParameters;
import org.cytoscape.cyndex2.internal.rest.parameter.LoadParameters;
import org.cytoscape.cyndex2.internal.rest.response.AppStatusResponse;
import org.cytoscape.cyndex2.internal.util.CIServiceManager;
import org.cytoscape.cyndex2.internal.util.ExternalAppManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NdexStatusResourceImpl
implements NdexStatusResource {
    private static final Logger logger = LoggerFactory.getLogger(NdexStatusResourceImpl.class);
    private final ErrorBuilder errorBuilder;
    private final CIServiceManager ciServiceManager;
    private AppStatusResponse<AppStatusParameters> status;

    public NdexStatusResourceImpl(CIServiceManager ciServiceManager) {
        this.ciServiceManager = ciServiceManager;
        this.errorBuilder = CyServiceModule.INSTANCE.getErrorBuilder();
    }

    @Override
    @CIWrapping
    public NdexStatusResource.CIAppStatusResponse getAppStatus() {
        String widget = ExternalAppManager.appName;
        if (widget == null) {
            widget = "choose";
        }
        this.status = new AppStatusResponse();
        if (widget.equals("choose")) {
            this.status.widget = "choose";
            this.status.parameters = LoadParameters.INSTANCE;
        } else {
            this.status.widget = "save";
            this.status.parameters = SaveParameters.INSTANCE;
        }
        try {
            return (NdexStatusResource.CIAppStatusResponse)this.ciServiceManager.getCIResponseFactory().getCIResponse(this.status, NdexStatusResource.CIAppStatusResponse.class);
        }
        catch (IllegalAccessException | InstantiationException e) {
            String message = "Could not create wrapped CI JSON.";
            logger.error("Could not create wrapped CI JSON.");
            throw this.errorBuilder.buildException(Response.Status.INTERNAL_SERVER_ERROR, "Could not create wrapped CI JSON.", ErrorType.INTERNAL);
        }
    }
}

