/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyndex2.internal;

import java.io.File;
import java.util.Dictionary;
import java.util.Properties;
import javax.swing.Icon;
import org.cytoscape.application.CyApplicationConfiguration;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CyAction;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.cyndex2.internal.CxTaskFactoryManager;
import org.cytoscape.cyndex2.internal.CyServiceModule;
import org.cytoscape.cyndex2.internal.rest.NdexClient;
import org.cytoscape.cyndex2.internal.rest.endpoints.NdexBaseResource;
import org.cytoscape.cyndex2.internal.rest.endpoints.NdexNetworkResource;
import org.cytoscape.cyndex2.internal.rest.endpoints.NdexStatusResource;
import org.cytoscape.cyndex2.internal.rest.endpoints.impl.NdexBaseResourceImpl;
import org.cytoscape.cyndex2.internal.rest.endpoints.impl.NdexNetworkResourceImpl;
import org.cytoscape.cyndex2.internal.rest.endpoints.impl.NdexStatusResourceImpl;
import org.cytoscape.cyndex2.internal.rest.errors.ErrorBuilder;
import org.cytoscape.cyndex2.internal.task.OpenBrowseTaskFactory;
import org.cytoscape.cyndex2.internal.task.OpenSaveCollectionTaskFactory;
import org.cytoscape.cyndex2.internal.task.OpenSaveTaskFactory;
import org.cytoscape.cyndex2.internal.ui.ImportNetworkFromNDExTaskFactory;
import org.cytoscape.cyndex2.internal.ui.ImportUserNetworkFromNDExTaskFactory;
import org.cytoscape.cyndex2.internal.ui.MainToolBarAction;
import org.cytoscape.cyndex2.internal.ui.SaveNetworkToNDExTaskFactory;
import org.cytoscape.cyndex2.internal.util.CIServiceManager;
import org.cytoscape.cyndex2.internal.util.IconUtil;
import org.cytoscape.io.read.InputStreamTaskFactory;
import org.cytoscape.io.write.CyNetworkViewWriterFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.AbstractCyActivator;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.NetworkCollectionTaskFactory;
import org.cytoscape.task.RootNetworkCollectionTaskFactory;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.TaskManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyActivator
extends AbstractCyActivator {
    private static final Logger logger = LoggerFactory.getLogger(CyActivator.class);
    private static CyProperty<Properties> cyProps;
    private static String appVersion;
    private static String cytoscapeVersion;
    private static String appName;
    private static boolean hasCyNDEx1;
    private CIServiceManager ciServiceManager;
    public static TaskManager<?, ?> taskManager;

    public CyActivator() {
        hasCyNDEx1 = false;
    }

    public static String getProperty(String prop) {
        return ((Properties)cyProps.getProperties()).getProperty(prop);
    }

    public static String getCyRESTPort() {
        String port = ((Properties)cyProps.getProperties()).getProperty("rest.port");
        if (port == null) {
            return "1234";
        }
        return port;
    }

    public static String getCytoscapeVersion() {
        String version = ((Properties)cyProps.getProperties()).getProperty("cytoscape.version.number");
        return version;
    }

    public static boolean useDefaultBrowser() {
        String val = ((Properties)cyProps.getProperties()).getProperty("cyndex2.defaultBrowser");
        return Boolean.parseBoolean(val);
    }

    public void start(BundleContext bc) throws InvalidSyntaxException {
        Bundle[] bundleArray = bc.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            if (b.getSymbolicName().equals("org.cytoscape.api-bundle")) {
                cytoscapeVersion = b.getVersion().toString();
            } else if (b.getSymbolicName().equals("org.cytoscape.ndex.cyNDEx")) {
                hasCyNDEx1 = true;
            }
            ++n2;
        }
        Bundle currentBundle = bc.getBundle();
        appVersion = currentBundle.getVersion().toString();
        Dictionary d = currentBundle.getHeaders();
        appName = (String)d.get("Bundle-name");
        CyServiceRegistrar serviceRegistrar = (CyServiceRegistrar)this.getService(bc, CyServiceRegistrar.class);
        CyServiceModule.setServiceRegistrar(serviceRegistrar);
        CyApplicationConfiguration config = (CyApplicationConfiguration)this.getService(bc, CyApplicationConfiguration.class);
        CyApplicationManager appManager = (CyApplicationManager)this.getService(bc, CyApplicationManager.class);
        CySwingApplication swingApplication = (CySwingApplication)this.getService(bc, CySwingApplication.class);
        CyServiceModule.setSwingApplication(swingApplication);
        cyProps = (CyProperty)this.getService(bc, CyProperty.class, "(cyPropertyName=cytoscape3.props)");
        taskManager = (TaskManager)this.getService(bc, TaskManager.class);
        File configDir = config.getAppConfigurationDirectoryLocation(CyActivator.class);
        configDir.mkdirs();
        CxTaskFactoryManager tfManager = CxTaskFactoryManager.INSTANCE;
        this.registerServiceListener(bc, tfManager, "addReaderFactory", "removeReaderFactory", InputStreamTaskFactory.class);
        this.registerServiceListener(bc, tfManager, "addWriterFactory", "removeWriterFactory", CyNetworkViewWriterFactory.class);
        this.ciServiceManager = new CIServiceManager(bc);
        CyNetworkManager netmgr = (CyNetworkManager)this.getService(bc, CyNetworkManager.class);
        OpenSaveTaskFactory ndexSaveNetworkTaskFactory = new OpenSaveTaskFactory(appManager);
        Properties ndexSaveNetworkTaskFactoryProps = new Properties();
        ndexSaveNetworkTaskFactoryProps.setProperty("preferredMenu", "File.Export");
        ndexSaveNetworkTaskFactoryProps.setProperty("menuGravity", "0.0");
        ndexSaveNetworkTaskFactoryProps.setProperty("title", "Network to NDEx...");
        this.registerService(bc, (Object)ndexSaveNetworkTaskFactory, TaskFactory.class, ndexSaveNetworkTaskFactoryProps);
        OpenSaveCollectionTaskFactory ndexSaveCollectionTaskFactory = new OpenSaveCollectionTaskFactory(appManager);
        Properties ndexSaveCollectionTaskFactoryProps = new Properties();
        ndexSaveCollectionTaskFactoryProps.setProperty("preferredMenu", "File.Export");
        ndexSaveCollectionTaskFactoryProps.setProperty("menuGravity", "0.1");
        ndexSaveCollectionTaskFactoryProps.setProperty("title", "Collection to NDEx...");
        this.registerService(bc, (Object)ndexSaveCollectionTaskFactory, TaskFactory.class, ndexSaveCollectionTaskFactoryProps);
        ImportNetworkFromNDExTaskFactory importFromNDExTaskFactory = new ImportNetworkFromNDExTaskFactory("choose");
        ImportUserNetworkFromNDExTaskFactory importUserNetworkTaskFactory = new ImportUserNetworkFromNDExTaskFactory("choose");
        SaveNetworkToNDExTaskFactory saveToNDExTaskFactory = new SaveNetworkToNDExTaskFactory(appManager, "save");
        MainToolBarAction action = new MainToolBarAction(importFromNDExTaskFactory, importUserNetworkTaskFactory, saveToNDExTaskFactory, serviceRegistrar);
        this.registerService(bc, (Object)action, CyAction.class);
        Icon icon = IconUtil.getNdexIcon();
        OpenBrowseTaskFactory ndexTaskFactory = new OpenBrowseTaskFactory(icon);
        Properties ndexTaskFactoryProps = new Properties();
        ndexTaskFactoryProps.setProperty("preferredMenu", "File.Import");
        ndexTaskFactoryProps.setProperty("menuGravity", "0.0");
        ndexTaskFactoryProps.setProperty("title", "Network from NDEx...");
        this.registerAllServices(bc, (Object)ndexTaskFactory, ndexTaskFactoryProps);
        ErrorBuilder errorBuilder = new ErrorBuilder(this.ciServiceManager, config);
        NdexClient ndexClient = new NdexClient(errorBuilder);
        CyServiceModule.setErrorBuilder(errorBuilder);
        this.registerService(bc, new NdexBaseResourceImpl(bc.getBundle().getVersion().toString(), this.ciServiceManager), NdexBaseResource.class, new Properties());
        this.registerService(bc, new NdexStatusResourceImpl(this.ciServiceManager), NdexStatusResource.class, new Properties());
        this.registerService(bc, new NdexNetworkResourceImpl(ndexClient, appManager, netmgr, this.ciServiceManager), NdexNetworkResource.class, new Properties());
        OpenSaveTaskFactory saveNetworkToNDExContextMenuTaskFactory = new OpenSaveTaskFactory(appManager);
        Properties saveNetworkToNDExContextMenuProps = new Properties();
        saveNetworkToNDExContextMenuProps.setProperty("id", "exportToNDEx");
        saveNetworkToNDExContextMenuProps.setProperty("title", "Export Network to NDEx".concat("..."));
        saveNetworkToNDExContextMenuProps.setProperty("inNetworkPanelContextMenu", "true");
        saveNetworkToNDExContextMenuProps.setProperty("insertSeparatorBefore", "true");
        saveNetworkToNDExContextMenuProps.setProperty("enableFor", "network");
        this.registerService(bc, (Object)saveNetworkToNDExContextMenuTaskFactory, NetworkCollectionTaskFactory.class, saveNetworkToNDExContextMenuProps);
        OpenSaveCollectionTaskFactory saveCollectionToNDExContextMenuTaskFactory = new OpenSaveCollectionTaskFactory(appManager);
        Properties saveCollectionToNDExContextMenuProps = new Properties();
        saveNetworkToNDExContextMenuProps.setProperty("id", "saveCollectionToNDEx");
        saveCollectionToNDExContextMenuProps.setProperty("title", "Export Collection to NDEx".concat("..."));
        saveCollectionToNDExContextMenuProps.setProperty("inNetworkPanelContextMenu", "true");
        saveCollectionToNDExContextMenuProps.setProperty("menuGravity", "1.0");
        this.registerService(bc, (Object)saveCollectionToNDExContextMenuTaskFactory, RootNetworkCollectionTaskFactory.class, saveCollectionToNDExContextMenuProps);
    }

    public void shutDown() {
        logger.info("Shutting down CyNDEx-2...");
        if (this.ciServiceManager != null) {
            this.ciServiceManager.close();
        }
        super.shutDown();
    }

    public static String getCyVersion() {
        return cytoscapeVersion;
    }

    public static String getAppName() {
        return appName;
    }

    public static boolean hasCyNDEx1() {
        return hasCyNDEx1;
    }

    public static void setHasCyNDEX1(boolean hasCyNDEx1) {
        CyActivator.hasCyNDEx1 = hasCyNDEx1;
    }

    public static String getAppVersion() {
        return appVersion;
    }
}

