/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.layout.internal.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.command.util.NodeList;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.View;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;
import org.cytoscape.work.util.ListSingleSelection;

public class LayoutWrapperTask
extends AbstractTask {
    private final CyApplicationManager appMgr;
    private final CyNetworkViewManager viewMgr;
    private final CyServiceRegistrar serviceRegistrar;
    List<CyNode> nodes = null;
    private final CyLayoutAlgorithm algorithm;
    private static final String UNWEIGHTED = "(none)";
    @Tunable(description="Network to lay out", context="nogui", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current")
    public CyNetwork network = null;
    @Tunable(description="Nodes to layout", context="nogui", longDescription="Specifies a list of nodes. The keywords ```all```, ```selected```, or ```unselected``` can be used to specify nodes by their selection state. The pattern ```COLUMN:VALUE``` sets this parameter to any rows that contain the specified column value; if the ```COLUMN``` prefix is not used, the NAME column is matched by default. A list of ```COLUMN:VALUE``` pairs of the format ```COLUMN1:VALUE1,COLUMN2:VALUE2,...``` can be used to match multiple values.", exampleStringValue="selected")
    public NodeList nodeList = new NodeList(null);
    ListSingleSelection<String> possibleEdgeAttributes = null;
    ListSingleSelection<String> possibleNodeAttributes = null;
    @ContainsTunables
    public Object layoutContext;

    public NodeList getnodeList() {
        if (this.network == null) {
            this.network = this.appMgr.getCurrentNetwork();
        }
        this.nodeList.setNetwork(this.network);
        return this.nodeList;
    }

    public void setnodeList(NodeList setValue) {
    }

    @Tunable(description="Edge column to use to weight layout", context="nogui", longDescription="The name of the edge column containing numeric values that will be used as weights in the layout algorithm. Only columns containing numeric values are shown", exampleStringValue="weight")
    public ListSingleSelection<String> getEdgeAttribute() {
        List<String> attrs;
        if (this.network == null) {
            this.network = this.appMgr.getCurrentNetwork();
        }
        this.possibleEdgeAttributes = (attrs = this.getSupportedEdgeAttributes()) == null || attrs.size() == 0 ? null : new ListSingleSelection(attrs);
        return this.possibleEdgeAttributes;
    }

    public void setEdgeAttribute(ListSingleSelection<String> setValue) {
    }

    @Tunable(description="Node column to use to weight layout", context="nogui", longDescription="The name of the node column containing numeric values that will be used as weights in the layout algorithm. Only columns containing numeric values are shown", exampleStringValue="weight")
    public ListSingleSelection<String> getNodeAttribute() {
        List<String> attrs;
        if (this.network == null) {
            this.network = this.appMgr.getCurrentNetwork();
        }
        this.possibleNodeAttributes = (attrs = this.getSupportedNodeAttributes()) == null || attrs.size() == 0 ? null : new ListSingleSelection(attrs);
        return this.possibleNodeAttributes;
    }

    public void setNodeAttribute(ListSingleSelection<String> setValue) {
    }

    public LayoutWrapperTask(CyApplicationManager appMgr, CyNetworkViewManager viewMgr, CyLayoutAlgorithm alg, CyServiceRegistrar serviceRegistrar) {
        this.appMgr = appMgr;
        this.viewMgr = viewMgr;
        this.algorithm = alg;
        this.serviceRegistrar = serviceRegistrar;
        this.layoutContext = alg.getDefaultLayoutContext();
    }

    public void run(TaskMonitor taskMonitor) {
        if (this.network == null) {
            this.network = this.appMgr.getCurrentNetwork();
        }
        Collection views = this.viewMgr.getNetworkViews(this.network);
        this.nodes = this.nodeList.getValue();
        for (CyNetworkView view : views) {
            Set<View> nodeViews = new HashSet();
            if (this.nodes == null || this.nodes.size() == 0) {
                nodeViews = CyLayoutAlgorithm.ALL_NODE_VIEWS;
            } else {
                for (CyNode node : this.nodes) {
                    nodeViews.add(view.getNodeView(node));
                }
            }
            this.insertTasksAfterCurrentTask(this.algorithm.createTaskIterator(view, this.layoutContext, nodeViews, this.getLayoutAttribute()));
        }
    }

    public Object getResults(Class type) {
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> "{}";
            return res;
        }
        return null;
    }

    private List<String> getSupportedEdgeAttributes() {
        Set supportedEdgeTypes = this.algorithm.getSupportedEdgeAttributeTypes();
        if (supportedEdgeTypes == null || supportedEdgeTypes.size() == 0) {
            return null;
        }
        return this.getSupportedAttributes(supportedEdgeTypes, this.network.getDefaultEdgeTable());
    }

    private List<String> getSupportedNodeAttributes() {
        Set supportedNodeTypes = this.algorithm.getSupportedNodeAttributeTypes();
        if (supportedNodeTypes == null || supportedNodeTypes.size() == 0) {
            return null;
        }
        return this.getSupportedAttributes(supportedNodeTypes, this.network.getDefaultNodeTable());
    }

    private List<String> getSupportedAttributes(Set<Class<?>> types, CyTable table) {
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add(UNWEIGHTED);
        block0: for (CyColumn column : table.getColumns()) {
            for (Class<?> type : types) {
                if (!column.getType().equals(type)) continue;
                attributes.add(column.getName());
                continue block0;
            }
        }
        if (attributes.size() > 1) {
            return attributes;
        }
        return null;
    }

    private String getLayoutAttribute() {
        if (this.possibleEdgeAttributes != null && !((String)this.possibleEdgeAttributes.getSelectedValue()).equals(UNWEIGHTED)) {
            return (String)this.possibleEdgeAttributes.getSelectedValue();
        }
        if (this.possibleNodeAttributes != null && !((String)this.possibleNodeAttributes.getSelectedValue()).equals(UNWEIGHTED)) {
            return (String)this.possibleNodeAttributes.getSelectedValue();
        }
        return null;
    }
}

