/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.layout.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.view.layout.internal.task.LayoutTaskFactoryWrapper;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.TaskFactory;

public class CyLayoutAlgorithmManagerImpl
implements CyLayoutAlgorithmManager {
    private final Map<String, CyLayoutAlgorithm> layoutMap;
    private final Map<String, String> layoutAttributeMap;
    private final Map<String, TaskFactory> serviceMap;
    private final CyServiceRegistrar serviceRegistrar;
    private CyApplicationManager appManager;
    private CyNetworkViewManager viewManager;

    public CyLayoutAlgorithmManagerImpl(CyLayoutAlgorithm defaultLayout, CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.layoutMap = new ConcurrentHashMap<String, CyLayoutAlgorithm>(16, 0.75f, 2);
        this.layoutAttributeMap = new ConcurrentHashMap<String, String>(16, 0.75f, 2);
        this.serviceMap = new ConcurrentHashMap<String, TaskFactory>(16, 0.75f, 2);
        if (serviceRegistrar != null) {
            this.appManager = (CyApplicationManager)serviceRegistrar.getService(CyApplicationManager.class);
            this.viewManager = (CyNetworkViewManager)serviceRegistrar.getService(CyNetworkViewManager.class);
        }
        this.addLayout(defaultLayout, new HashMap());
    }

    public void addLayout(CyLayoutAlgorithm layout, Map<?, ?> props) {
        if (layout != null) {
            this.layoutMap.put(layout.getName(), layout);
            if (this.serviceRegistrar != null && !layout.getName().startsWith("yfiles.")) {
                Properties layoutProps = new Properties();
                layoutProps.setProperty("command", layout.getName());
                layoutProps.setProperty("commandNamespace", "layout");
                layoutProps.setProperty("commandDescription", "Execute the " + layout.toString() + " on a network");
                layoutProps.setProperty("commandSupportsJSON", "true");
                layoutProps.setProperty("commandExampleJSON", "{}");
                LayoutTaskFactoryWrapper service = new LayoutTaskFactoryWrapper(this.appManager, this.viewManager, layout, this.serviceRegistrar);
                this.serviceRegistrar.registerService((Object)service, TaskFactory.class, layoutProps);
                this.serviceMap.put(layout.getName(), (TaskFactory)service);
            }
        }
    }

    public void removeLayout(CyLayoutAlgorithm layout, Map<?, ?> props) {
        if (layout != null) {
            this.layoutMap.remove(layout.getName());
            if (this.serviceRegistrar != null && this.serviceMap.containsKey(layout.getName())) {
                TaskFactory service = this.serviceMap.get(layout.getName());
                this.serviceRegistrar.unregisterService((Object)service, TaskFactory.class);
                this.serviceMap.remove(layout.getName());
            }
        }
    }

    public CyLayoutAlgorithm getLayout(String name) {
        if (name != null) {
            return this.layoutMap.get(name);
        }
        return null;
    }

    public Collection<CyLayoutAlgorithm> getAllLayouts() {
        return this.layoutMap.values();
    }

    public CyLayoutAlgorithm getDefaultLayout() {
        String defaultLayout = ((Properties)this.getCoreCyProperty().getProperties()).getProperty("layout.default");
        if (defaultLayout == null || !this.layoutMap.containsKey(defaultLayout)) {
            defaultLayout = "force-directed";
        }
        return this.layoutMap.get(defaultLayout);
    }

    public CyLayoutAlgorithm setDefaultLayout(CyLayoutAlgorithm layout) {
        if (layout == null) {
            throw new IllegalArgumentException("The default layout algorithm cannot be null.");
        }
        if (!this.layoutMap.values().contains(layout)) {
            throw new IllegalArgumentException("The layout algorithm is not registered.");
        }
        ((Properties)this.getCoreCyProperty().getProperties()).setProperty("layout.default", layout.getName());
        return null;
    }

    private CyProperty<Properties> getCoreCyProperty() {
        return (CyProperty)this.serviceRegistrar.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)");
    }

    public String getLayoutAttribute(CyLayoutAlgorithm layout, CyNetworkView view) {
        String attribute = this.layoutAttributeMap.get(layout.getName());
        if (attribute == null || attribute.isEmpty()) {
            return "";
        }
        if (view == null) {
            return attribute;
        }
        Set edgeTypes = layout.getSupportedEdgeAttributeTypes();
        Set nodeTypes = layout.getSupportedNodeAttributeTypes();
        CyTable tableToCheck = null;
        if (edgeTypes != null && !edgeTypes.isEmpty()) {
            tableToCheck = ((CyNetwork)view.getModel()).getDefaultEdgeTable();
        } else if (nodeTypes != null && !nodeTypes.isEmpty()) {
            tableToCheck = ((CyNetwork)view.getModel()).getDefaultNodeTable();
        }
        if (tableToCheck == null || tableToCheck.getColumn(attribute) == null) {
            return "";
        }
        return attribute;
    }

    public void setLayoutAttribute(CyLayoutAlgorithm layout, String layoutAttribute) {
        if (layoutAttribute == null) {
            this.layoutAttributeMap.remove(layout.getName());
        } else {
            this.layoutAttributeMap.put(layout.getName(), layoutAttribute);
        }
    }
}

