/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.parse_tree;

import java.util.Stack;
import org.cytoscape.equations.AbstractNode;
import org.cytoscape.equations.CodeAndSourceLocation;
import org.cytoscape.equations.TreeNode;
import org.cytoscape.equations.internal.interpreter.Instruction;

public class FConvNode
extends AbstractNode {
    private final TreeNode convertee;

    public FConvNode(TreeNode convertee) {
        super(-1);
        if (convertee == null) {
            throw new IllegalArgumentException("convertee must not be null.");
        }
        Class type = convertee.getType();
        if (type != Long.class && type != Boolean.class && type != String.class && type != Integer.class) {
            throw new IllegalArgumentException("convertee must be of type Long, Integer, Boolean or String.");
        }
        this.convertee = convertee;
    }

    public String toString() {
        return "FConvNode: convertee = " + this.convertee;
    }

    public Class getType() {
        return Double.class;
    }

    public TreeNode getLeftChild() {
        return this.convertee;
    }

    public TreeNode getRightChild() {
        return null;
    }

    public void genCode(Stack<CodeAndSourceLocation> codeStack) {
        this.convertee.genCode(codeStack);
        Class type = this.convertee.getType();
        if (type == Long.class || type == Integer.class) {
            codeStack.push(new CodeAndSourceLocation((Object)Instruction.FCONVI, this.getSourceLocation()));
        } else if (type == Boolean.class) {
            codeStack.push(new CodeAndSourceLocation((Object)Instruction.FCONVB, this.getSourceLocation()));
        } else if (type == String.class) {
            codeStack.push(new CodeAndSourceLocation((Object)Instruction.FCONVS, this.getSourceLocation()));
        } else {
            throw new IllegalStateException("unknown type: " + type + ".");
        }
    }
}

