/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class Radians
extends AbstractFunction {
    public Radians() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.FLOAT, "angle", "An angle in degrees.")});
    }

    public String getName() {
        return "RADIANS";
    }

    public String getCategoryName() {
        return "Numeric";
    }

    public String getFunctionSummary() {
        return "Returns the value in radians converted from degrees.";
    }

    public Class<?> getReturnType() {
        return Double.class;
    }

    public Object evaluateFunction(Object[] args) {
        double angleInDegrees = FunctionUtil.getArgAsDouble((Object)args[0]);
        return angleInDegrees * Math.PI / 180.0;
    }
}

