/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.builtins;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;

public class Now
extends AbstractFunction {
    public Now() {
        super(new ArgDescriptor[0]);
    }

    public String getName() {
        return "NOW";
    }

    public String getCategoryName() {
        return "Date/Time";
    }

    public String getFunctionSummary() {
        return "Returns the current date and time as a string (text).";
    }

    public Class<?> getReturnType() {
        return Double.class;
    }

    public Object evaluateFunction(Object[] args) {
        Calendar calendar = Calendar.getInstance();
        DateFormat dateFormat = DateFormat.getDateInstance(3);
        DateFormat timeFormat = DateFormat.getTimeInstance(3);
        try {
            Date now = calendar.getTime();
            String date = dateFormat.format(now);
            String time = timeFormat.format(now);
            return date + " " + time;
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to get today's date: " + e.getMessage());
        }
    }
}

