/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class Ln
extends AbstractFunction {
    public Ln() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.FLOAT, "number", "A positive number.")});
    }

    public String getName() {
        return "LN";
    }

    public String getCategoryName() {
        return "Numeric";
    }

    public String getFunctionSummary() {
        return "Returns the natural logarithm of a number.";
    }

    public Class<?> getReturnType() {
        return Double.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        double number;
        try {
            number = FunctionUtil.getArgAsDouble((Object)args[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't convert \"" + args[0] + "\" to a number in a call to LN().");
        }
        if (number <= 0.0) {
            throw new IllegalArgumentException("LN() called with a number <= 0.0.");
        }
        return Math.log(number);
    }
}

