/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionError;
import org.cytoscape.equations.FunctionUtil;

public class HarMean
extends AbstractFunction {
    public HarMean() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.FLOATS, "numbers", "Two or more positive numbers.")});
    }

    public String getName() {
        return "HARMEAN";
    }

    public String getCategoryName() {
        return "Numeric";
    }

    public String getFunctionSummary() {
        return "Returns the harmonic mean of a set of numbers.";
    }

    public Class<?> getReturnType() {
        return Double.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        double[] numbers;
        try {
            numbers = FunctionUtil.getDoubles((Object[])args);
        }
        catch (FunctionError e) {
            throw new IllegalArgumentException("bad argument in a call to HARMEAN(): " + e.getMessage());
        }
        if (!this.isPositiveArray(numbers)) {
            throw new IllegalArgumentException("at least one argument to HARMEAN() is not positive.");
        }
        if (numbers.length < 2) {
            throw new IllegalArgumentException("illegal arguments in call to HARMEAN(): must have at least 2 numbers.");
        }
        double sum = 0.0;
        for (double d : numbers) {
            sum += 1.0 / d;
        }
        return (double)numbers.length / sum;
    }

    private boolean isPositiveArray(double[] numbers) {
        for (double d : numbers) {
            if (!(d <= 0.0)) continue;
            return false;
        }
        return true;
    }
}

