/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class Degrees
extends AbstractFunction {
    public Degrees() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.FLOAT, "angle", "An angle in radians.")});
    }

    public String getName() {
        return "DEGREES";
    }

    public String getCategoryName() {
        return "Numeric";
    }

    public String getFunctionSummary() {
        return "Returns the value in degrees converted from radians.";
    }

    public Class<?> getReturnType() {
        return Double.class;
    }

    public Object evaluateFunction(Object[] args) {
        double angleInRadians = FunctionUtil.getArgAsDouble((Object)args[0]);
        return angleInRadians * 180.0 / Math.PI;
    }
}

