/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class Concatenate
extends AbstractFunction {
    public Concatenate() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.OPT_STRINGS, "values", "Zero or more numbers, strings or booleans or lists thereof.")});
    }

    public String getName() {
        return "CONCATENATE";
    }

    public String getCategoryName() {
        return "Text";
    }

    public String getFunctionSummary() {
        return "Converts each argument to a string (text), then joins them end-to-end into a single string.";
    }

    public Class<?> getReturnType() {
        return String.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        String[] strings = FunctionUtil.getStrings((Object[])args);
        int totalLength = 0;
        for (String s : strings) {
            totalLength += s.length();
        }
        StringBuilder builder = new StringBuilder(totalLength);
        for (String s : strings) {
            builder.append(s);
        }
        return builder.toString();
    }
}

