/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;
import org.cytoscape.equations.internal.BooleanList;

public class BList
extends AbstractFunction {
    public BList() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.OPT_STRINGS, "truth_values", "Zero or more numbers, strings or booleans.")});
    }

    public String getName() {
        return "BLIST";
    }

    public String getCategoryName() {
        return "List";
    }

    public String getFunctionSummary() {
        return "Returns a list of boolean values.";
    }

    public Class<?> getReturnType() {
        return BooleanList.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        boolean[] booleans;
        try {
            booleans = FunctionUtil.getBooleans((Object[])args);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't convert an argument or a list element to a boolean in a call to BLIST().");
        }
        return new BooleanList(booleans);
    }
}

