/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class ASin
extends AbstractFunction {
    public ASin() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.FLOAT, "number", "A number between -1 and +1, inclusive.")});
    }

    public String getName() {
        return "ASIN";
    }

    public String getCategoryName() {
        return "Numeric";
    }

    public String getFunctionSummary() {
        return "Returns the arcsine of a number.";
    }

    public Class<?> getReturnType() {
        return Double.class;
    }

    public Object evaluateFunction(Object[] args) {
        double arg = FunctionUtil.getArgAsDouble((Object)args[0]);
        if (arg < -1.0 || arg > 1.0) {
            throw new IllegalArgumentException("the argument to ASIN() must be in [-1,+1].");
        }
        return Math.asin(arg);
    }
}

