/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.cytoscape.equations.EquationTokeniser;
import org.cytoscape.equations.Token;
import org.cytoscape.equations.internal.Token;
import org.cytoscape.equations.internal.Tokeniser;

public class EquationTokeniserImpl
implements EquationTokeniser {
    public Iterator<org.cytoscape.equations.Token> getTokenIterator(String equation) {
        final Tokeniser tokeniser = new Tokeniser(equation);
        return new Iterator<org.cytoscape.equations.Token>(){
            boolean done;

            @Override
            public boolean hasNext() {
                return !this.done;
            }

            @Override
            public org.cytoscape.equations.Token next() {
                if (this.done) {
                    throw new NoSuchElementException();
                }
                org.cytoscape.equations.Token t = EquationTokeniserImpl.getNextApiToken(tokeniser);
                if (t == null || t.getType() == Token.Type.EOS || t.getType() == Token.Type.ERROR) {
                    this.done = true;
                }
                return t;
            }
        };
    }

    private static org.cytoscape.equations.Token getNextApiToken(Tokeniser tokeniser) {
        int start;
        Token implToken = tokeniser.getToken();
        Token.Type type = EquationTokeniserImpl.tokenToTokenType(implToken);
        int end = start = tokeniser.getStartPos();
        switch (type) {
            case IDENTIFIER: {
                end += tokeniser.getIdent().length() - 1;
                break;
            }
            case STRING_CONSTANT: {
                end += tokeniser.getCurrentStringLiteralLength() - 1;
                break;
            }
            case BOOLEAN_CONSTANT: {
                end += tokeniser.getBooleanConstant() ? 3 : 4;
                break;
            }
            case FLOAT_CONSTANT: {
                end += tokeniser.getFloatString().length() - 1;
                break;
            }
            case LESS_OR_EQUAL: 
            case GREATER_OR_EQUAL: 
            case NOT_EQUAL: {
                ++end;
                break;
            }
            case ERROR: {
                end = tokeniser.getEquation().length() - 1;
            }
        }
        return new org.cytoscape.equations.Token(type, start, end);
    }

    private static Token.Type tokenToTokenType(Token implToken) {
        switch (implToken) {
            case AMPERSAND: {
                return Token.Type.AMPERSAND;
            }
            case BOOLEAN_CONSTANT: {
                return Token.Type.BOOLEAN_CONSTANT;
            }
            case CARET: {
                return Token.Type.CARET;
            }
            case CLOSE_BRACE: {
                return Token.Type.CLOSE_BRACE;
            }
            case CLOSE_PAREN: {
                return Token.Type.CLOSE_PAREN;
            }
            case COLON: {
                return Token.Type.COLON;
            }
            case COMMA: {
                return Token.Type.COMMA;
            }
            case DIV: {
                return Token.Type.DIV;
            }
            case DOLLAR: {
                return Token.Type.DOLLAR;
            }
            case EOS: {
                return Token.Type.EOS;
            }
            case EQUAL: {
                return Token.Type.EQUAL;
            }
            case ERROR: {
                return Token.Type.ERROR;
            }
            case FLOAT_CONSTANT: {
                return Token.Type.FLOAT_CONSTANT;
            }
            case GREATER_OR_EQUAL: {
                return Token.Type.GREATER_OR_EQUAL;
            }
            case GREATER_THAN: {
                return Token.Type.GREATER_THAN;
            }
            case IDENTIFIER: {
                return Token.Type.IDENTIFIER;
            }
            case LESS_OR_EQUAL: {
                return Token.Type.LESS_OR_EQUAL;
            }
            case LESS_THAN: {
                return Token.Type.LESS_THAN;
            }
            case MINUS: {
                return Token.Type.MINUS;
            }
            case MUL: {
                return Token.Type.MUL;
            }
            case NOT_EQUAL: {
                return Token.Type.NOT_EQUAL;
            }
            case OPEN_BRACE: {
                return Token.Type.OPEN_BRACE;
            }
            case OPEN_PAREN: {
                return Token.Type.OPEN_PAREN;
            }
            case PLUS: {
                return Token.Type.PLUS;
            }
            case STRING_CONSTANT: {
                return Token.Type.STRING_CONSTANT;
            }
        }
        return null;
    }
}

