/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.cytoscape.equations.CodeAndSourceLocation;
import org.cytoscape.equations.Equation;
import org.cytoscape.equations.EquationCompiler;
import org.cytoscape.equations.EquationParser;
import org.cytoscape.equations.TreeNode;

public class EquationCompilerImpl
implements EquationCompiler {
    private final EquationParser parser;
    private Equation equation;
    private String errorMsg;
    private int errorLocation;

    public EquationCompilerImpl(EquationParser parser) {
        this.parser = parser;
    }

    public boolean compile(String equation, Map<String, Class<?>> variableNameToTypeMap) {
        this.equation = null;
        this.errorMsg = null;
        this.errorLocation = -1;
        if (!this.parser.parse(equation, variableNameToTypeMap)) {
            this.errorMsg = this.parser.getErrorMsg();
            this.errorLocation = this.parser.getErrorLocation();
            return false;
        }
        TreeNode parseTree = this.parser.getParseTree();
        Stack codeStack = new Stack();
        try {
            parseTree.genCode(codeStack);
        }
        catch (IllegalStateException e) {
            this.errorMsg = e.getCause().toString();
            return false;
        }
        Object[] code = new Object[codeStack.size()];
        int[] sourceLocations = new int[codeStack.size()];
        for (int i = code.length - 1; i >= 0; --i) {
            CodeAndSourceLocation codeAndSourceLocation = (CodeAndSourceLocation)codeStack.pop();
            code[i] = codeAndSourceLocation.getCode();
            sourceLocations[i] = codeAndSourceLocation.getSourceLocation();
        }
        this.equation = new Equation(equation, this.parser.getVariableReferences(), this.parser.getDefaultVariableValues(), code, sourceLocations, this.parser.getType());
        this.errorMsg = null;
        return true;
    }

    public String getLastErrorMsg() {
        return this.errorMsg;
    }

    public int getErrorLocation() {
        return this.errorLocation;
    }

    public Equation getEquation() {
        return this.equation;
    }

    public EquationParser getParser() {
        return this.parser;
    }

    public Equation getErrorEquation(String equation, Class<?> type, String errorMessage) {
        HashMap variableNameToTypeMap = new HashMap();
        if (!this.compile("=ERROR(\"" + EquationCompilerImpl.escapeQuotes(errorMessage) + "\")", variableNameToTypeMap)) {
            throw new IllegalStateException("internal error in Equation.getErrorEquation().  This should *never* happen.");
        }
        Equation errorEquation = this.getEquation();
        return new Equation(equation, errorEquation.getVariableReferences(), errorEquation.getDefaultVariableValues(), errorEquation.getCode(), errorEquation.getSourceLocations(), type);
    }

    private static String escapeQuotes(String s) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '\"') {
                builder.append('\\');
            }
            builder.append(ch);
        }
        return builder.toString();
    }
}

