/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.model.internal.network.spacial;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.BooleanSupplier;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.SnapshotEdgeInfo;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.internal.network.snapshot.CyNetworkViewSnapshotImpl;
import org.cytoscape.view.model.internal.network.snapshot.CyNodeViewSnapshotImpl;
import org.cytoscape.view.model.spacial.EdgeSpacialIndex2DEnumerator;
import org.cytoscape.view.model.spacial.NetworkSpacialIndex2D;
import org.cytoscape.view.model.spacial.NodeSpacialIndex2DEnumerator;
import org.cytoscape.view.model.spacial.SpacialIndex2DEnumerator;

public class SimpleSpacialIndex2DSnapshotImpl
implements NetworkSpacialIndex2D {
    private final CyNetworkViewSnapshotImpl snapshot;
    private double[] mbrd = null;
    private float[] mbrf = null;
    private Comparator<View<CyNode>> nodeZComparator;
    private Comparator<View<CyEdge>> edgeZComparator;
    private QueryResults cachedQueryResults;

    public SimpleSpacialIndex2DSnapshotImpl(CyNetworkViewSnapshotImpl snapshot) {
        this.snapshot = snapshot;
        this.nodeZComparator = Comparator.comparing(node -> snapshot.getNodeZ(node.getSUID()));
        this.edgeZComparator = Comparator.comparing(edge -> snapshot.getEdgeZ(edge.getSUID()));
    }

    public void getMBR(float[] extents) {
        this.initMBR();
        if (extents != null) {
            extents[0] = this.mbrf[0];
            extents[1] = this.mbrf[1];
            extents[2] = this.mbrf[2];
            extents[3] = this.mbrf[3];
        }
    }

    public void getMBR(double[] extents) {
        this.initMBR();
        if (extents != null) {
            extents[0] = this.mbrd[0];
            extents[1] = this.mbrd[1];
            extents[2] = this.mbrd[2];
            extents[3] = this.mbrd[3];
        }
    }

    private void initMBR() {
        if (this.mbrd == null || this.mbrf == null) {
            Iterator<CyNodeViewSnapshotImpl> iter = this.snapshot.getSnapshotNodeViews().iterator();
            if (!iter.hasNext()) {
                this.mbrd = new double[4];
                this.mbrf = new float[4];
            } else {
                CyNodeViewSnapshotImpl node = iter.next();
                double x = node.x;
                double y = node.y;
                double h = node.h;
                double w = node.w;
                double xMin = x - w / 2.0;
                double xMax = x + w / 2.0;
                double yMin = y - h / 2.0;
                double yMax = y + h / 2.0;
                while (iter.hasNext()) {
                    node = iter.next();
                    x = node.x;
                    y = node.y;
                    h = node.h;
                    w = node.w;
                    xMin = Math.min(xMin, x - w / 2.0);
                    xMax = Math.max(xMax, x + w / 2.0);
                    yMin = Math.min(yMin, y - h / 2.0);
                    yMax = Math.max(yMax, y + h / 2.0);
                }
                this.mbrd = new double[4];
                this.mbrd[0] = xMin;
                this.mbrd[2] = xMax;
                this.mbrd[1] = yMin;
                this.mbrd[3] = yMax;
                this.mbrf = new float[4];
                this.mbrf[0] = (float)xMin;
                this.mbrf[2] = (float)xMax;
                this.mbrf[1] = (float)yMin;
                this.mbrf[3] = (float)yMax;
            }
        }
    }

    public boolean exists(Long suid) {
        return this.snapshot.getNodeView(suid) != null;
    }

    public boolean get(Long suid, float[] extents) {
        CyNodeViewSnapshotImpl node = this.snapshot.getNodeView(suid);
        if (node == null) {
            return false;
        }
        SimpleSpacialIndex2DSnapshotImpl.copyExtents(node, extents);
        return true;
    }

    public boolean get(Long suid, double[] extents) {
        CyNodeViewSnapshotImpl node = this.snapshot.getNodeView(suid);
        if (node == null) {
            return false;
        }
        SimpleSpacialIndex2DSnapshotImpl.copyExtents(node, extents);
        return true;
    }

    private static void copyExtents(CyNodeViewSnapshotImpl node, float[] extents) {
        if (extents != null) {
            double x = node.x;
            double y = node.y;
            double h = node.h;
            double w = node.w;
            extents[0] = (float)(x - w / 2.0);
            extents[2] = (float)(x + w / 2.0);
            extents[1] = (float)(y - h / 2.0);
            extents[3] = (float)(y + h / 2.0);
        }
    }

    private static void copyExtents(CyNodeViewSnapshotImpl node, double[] extents) {
        if (extents != null) {
            double x = node.x;
            double y = node.y;
            double h = node.h;
            double w = node.w;
            extents[0] = x - w / 2.0;
            extents[2] = x + w / 2.0;
            extents[1] = y - h / 2.0;
            extents[3] = y + h / 2.0;
        }
    }

    public int size() {
        return this.snapshot.getNodeCount();
    }

    private QueryResults computeQueryOverlap(float xMin, float yMin, float xMax, float yMax, BooleanSupplier isCancelled) {
        this.initMBR();
        xMin = Math.max(xMin, this.mbrf[0]);
        yMin = Math.max(yMin, this.mbrf[1]);
        xMax = Math.min(xMax, this.mbrf[2]);
        yMax = Math.min(yMax, this.mbrf[3]);
        QueryResults cache = this.cachedQueryResults;
        if (cache != null && cache.matches(xMin, yMin, xMax, yMax)) {
            return cache;
        }
        ArrayList<CyNodeViewSnapshotImpl> overlapNodes = new ArrayList<CyNodeViewSnapshotImpl>();
        for (CyNodeViewSnapshotImpl node : this.snapshot.getSnapshotNodeViews()) {
            if (isCancelled != null && isCancelled.getAsBoolean()) {
                return null;
            }
            double x = node.x;
            double w = node.w;
            double aMin = x - w / 2.0;
            double y = node.y;
            double h = node.h;
            double bMin = y - h / 2.0;
            double aMax = x + w / 2.0;
            double bMax = y + h / 2.0;
            if (!SimpleSpacialIndex2DSnapshotImpl.intersects(xMin, yMin, xMax, yMax, aMin, bMin, aMax, bMax)) continue;
            overlapNodes.add(node);
        }
        Collections.sort(overlapNodes, this.nodeZComparator);
        this.cachedQueryResults = new QueryResults(xMin, yMin, xMax, yMax, overlapNodes);
        return this.cachedQueryResults;
    }

    public SpacialIndex2DEnumerator<Long> queryAll() {
        this.initMBR();
        return this.queryOverlap(this.mbrf[0], this.mbrf[1], this.mbrf[2], this.mbrf[3]);
    }

    public SpacialIndex2DEnumerator<Long> queryOverlap(float xMin, float yMin, float xMax, float yMax) {
        QueryResults cache = this.computeQueryOverlap(xMin, yMin, xMax, yMax, null);
        return new SimpleNodeEnumerator(cache.getOverlapNodes());
    }

    public NodeSpacialIndex2DEnumerator queryAllNodes(BooleanSupplier isCancelled) {
        this.initMBR();
        return this.queryOverlapNodes(this.mbrf[0], this.mbrf[1], this.mbrf[2], this.mbrf[3], isCancelled);
    }

    public NodeSpacialIndex2DEnumerator queryOverlapNodes(float xMin, float yMin, float xMax, float yMax, BooleanSupplier isCancelled) {
        QueryResults cache = this.computeQueryOverlap(xMin, yMin, xMax, yMax, isCancelled);
        if (cache == null) {
            return null;
        }
        return new SimpleNodeEnumerator(cache.getOverlapNodes());
    }

    public EdgeSpacialIndex2DEnumerator queryAllEdges(BooleanSupplier isCancelled) {
        this.initMBR();
        return this.queryOverlapEdges(this.mbrf[0], this.mbrf[1], this.mbrf[2], this.mbrf[3], isCancelled);
    }

    public EdgeSpacialIndex2DEnumerator queryOverlapEdges(float xMin, float yMin, float xMax, float yMax, BooleanSupplier isCancelled) {
        QueryResults cache = this.computeQueryOverlap(xMin, yMin, xMax, yMax, isCancelled);
        if (cache == null) {
            return null;
        }
        List<View<CyEdge>> adjacentEdges = cache.getAdjacentEdges(isCancelled);
        if (adjacentEdges == null) {
            return null;
        }
        return new SimpleEdgeEnumerator(adjacentEdges);
    }

    private static boolean intersects(float x1, float y1, float x2, float y2, double a1, double b1, double a2, double b2) {
        return (double)x1 <= a2 && a1 <= (double)x2 && (double)y1 <= b2 && b1 <= (double)y2;
    }

    private class SimpleEdgeEnumerator
    implements EdgeSpacialIndex2DEnumerator {
        private final int size;
        private final Iterator<View<CyEdge>> iter;

        public SimpleEdgeEnumerator(List<View<CyEdge>> edges) {
            this.size = edges.size();
            this.iter = edges.iterator();
        }

        public int size() {
            return this.size;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public View<CyEdge> nextEdge() {
            return this.iter.next();
        }

        public View<CyEdge> nextEdgeWithNodeExtents(float[] sourceExtents, float[] targetExtents, View<CyNode>[] nodes) {
            View<CyEdge> edge = this.iter.next();
            SnapshotEdgeInfo edgeInfo = SimpleSpacialIndex2DSnapshotImpl.this.snapshot.getEdgeInfo(edge);
            CyNodeViewSnapshotImpl sourceNode = SimpleSpacialIndex2DSnapshotImpl.this.snapshot.getNodeView(edgeInfo.getSourceViewSUID());
            CyNodeViewSnapshotImpl targetNode = SimpleSpacialIndex2DSnapshotImpl.this.snapshot.getNodeView(edgeInfo.getTargetViewSUID());
            SimpleSpacialIndex2DSnapshotImpl.copyExtents(sourceNode, sourceExtents);
            SimpleSpacialIndex2DSnapshotImpl.copyExtents(targetNode, targetExtents);
            if (nodes != null && nodes.length >= 2) {
                nodes[0] = sourceNode;
                nodes[1] = targetNode;
            }
            return edge;
        }
    }

    private class SimpleNodeEnumerator
    implements NodeSpacialIndex2DEnumerator {
        private final int size;
        private final Iterator<CyNodeViewSnapshotImpl> iter;

        public SimpleNodeEnumerator(List<CyNodeViewSnapshotImpl> nodes) {
            this.size = nodes.size();
            this.iter = nodes.iterator();
        }

        public int size() {
            return this.size;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Long nextExtents(float[] extents) {
            CyNodeViewSnapshotImpl node = this.iter.next();
            SimpleSpacialIndex2DSnapshotImpl.copyExtents(node, extents);
            return node.getSUID();
        }

        public View<CyNode> nextNode() {
            return this.iter.next();
        }

        public View<CyNode> nextNodeExtents(float[] extents) {
            CyNodeViewSnapshotImpl node = this.iter.next();
            SimpleSpacialIndex2DSnapshotImpl.copyExtents(node, extents);
            return node;
        }
    }

    private class QueryResults {
        private final float xMin;
        private final float yMin;
        private final float xMax;
        private final float yMax;
        private final List<CyNodeViewSnapshotImpl> overlapNodes;
        private List<View<CyEdge>> edges;

        QueryResults(float xMin, float yMin, float xMax, float yMax, List<CyNodeViewSnapshotImpl> overlapNodes) {
            this.xMin = xMin;
            this.yMin = yMin;
            this.xMax = xMax;
            this.yMax = yMax;
            this.overlapNodes = overlapNodes;
        }

        boolean matches(float xMin, float yMin, float xMax, float yMax) {
            return this.xMin == xMin && this.yMin == yMin && this.xMax == xMax && this.yMax == yMax;
        }

        List<CyNodeViewSnapshotImpl> getOverlapNodes() {
            return this.overlapNodes;
        }

        synchronized List<View<CyEdge>> getAdjacentEdges(BooleanSupplier isCancelled) {
            if (this.edges == null) {
                ArrayList<View<CyEdge>> tempEdges = new ArrayList<View<CyEdge>>();
                HashSet<Long> visitedNodes = new HashSet<Long>();
                for (CyNodeViewSnapshotImpl node : this.overlapNodes) {
                    if (isCancelled != null && isCancelled.getAsBoolean()) {
                        return null;
                    }
                    long nodeSuid = node.getSUID();
                    Iterable<View<CyEdge>> touchingEdges = SimpleSpacialIndex2DSnapshotImpl.this.snapshot.getAdjacentEdgeIterable(nodeSuid);
                    for (View<CyEdge> edge : touchingEdges) {
                        SnapshotEdgeInfo edgeInfo = SimpleSpacialIndex2DSnapshotImpl.this.snapshot.getEdgeInfo(edge);
                        long otherNode = nodeSuid ^ edgeInfo.getSourceViewSUID() ^ edgeInfo.getTargetViewSUID();
                        if (visitedNodes.contains(otherNode)) continue;
                        tempEdges.add(edge);
                    }
                    visitedNodes.add(nodeSuid);
                }
                if (SimpleSpacialIndex2DSnapshotImpl.this.snapshot.hasEdgeZ()) {
                    tempEdges.sort(SimpleSpacialIndex2DSnapshotImpl.this.edgeZComparator);
                }
                this.edges = tempEdges;
            }
            return this.edges;
        }
    }
}

