/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.model.internal.network;

import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.events.AboutToRemoveEdgesEvent;
import org.cytoscape.model.events.AboutToRemoveEdgesListener;
import org.cytoscape.model.events.AboutToRemoveNodesEvent;
import org.cytoscape.model.events.AboutToRemoveNodesListener;
import org.cytoscape.model.events.AddedEdgesEvent;
import org.cytoscape.model.events.AddedEdgesListener;
import org.cytoscape.model.events.AddedNodesEvent;
import org.cytoscape.model.events.AddedNodesListener;
import org.cytoscape.model.events.RowSetRecord;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.model.events.RowsSetListener;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.events.AboutToRemoveEdgeViewsEvent;
import org.cytoscape.view.model.events.AboutToRemoveNodeViewsEvent;
import org.cytoscape.view.model.events.AddedEdgeViewsEvent;
import org.cytoscape.view.model.events.AddedNodeViewsEvent;
import org.cytoscape.view.model.internal.network.CyNetworkViewImpl;
import org.cytoscape.view.model.internal.network.CyNodeViewImpl;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;

public class NetworkModelListener
implements AddedNodesListener,
AddedEdgesListener,
AboutToRemoveNodesListener,
AboutToRemoveEdgesListener,
RowsSetListener {
    private final CyNetworkViewImpl networkView;
    private final CyEventHelper eventHelper;

    public NetworkModelListener(CyNetworkViewImpl networkView, CyServiceRegistrar registrar) {
        this.networkView = networkView;
        this.eventHelper = (CyEventHelper)registrar.getService(CyEventHelper.class);
    }

    public void handleEvent(RowsSetEvent e) {
        block4: {
            CyNetwork model;
            CyTable table;
            block3: {
                if (!e.containsColumn("selected")) {
                    return;
                }
                table = (CyTable)e.getSource();
                if (table != (model = (CyNetwork)this.networkView.getModel()).getDefaultNodeTable()) break block3;
                for (RowSetRecord record : e.getColumnRecords("selected")) {
                    View<CyNode> nodeView;
                    Long suid = (Long)record.getRow().get("SUID", Long.class);
                    if (suid == null || (nodeView = this.networkView.getNodeViewByDataSuid(suid)) == null) continue;
                    nodeView.setVisualProperty(BasicVisualLexicon.NODE_SELECTED, record.getValue());
                }
                break block4;
            }
            if (table != model.getDefaultEdgeTable()) break block4;
            for (RowSetRecord record : e.getColumnRecords("selected")) {
                View<CyEdge> edgeView;
                Long suid = (Long)record.getRow().get("SUID", Long.class);
                if (suid == null || (edgeView = this.networkView.getEdgeViewByDataSuid(suid)) == null) continue;
                edgeView.setVisualProperty(BasicVisualLexicon.EDGE_SELECTED, record.getValue());
            }
        }
    }

    public void handleEvent(AddedNodesEvent e) {
        if (this.networkView.getModel() != e.getSource()) {
            return;
        }
        for (CyNode node : e.getPayloadCollection()) {
            CyNodeViewImpl view = this.networkView.addNode(node);
            if (view == null) continue;
            this.eventHelper.addEventPayload((Object)this.networkView, (Object)view, AddedNodeViewsEvent.class);
        }
    }

    public void handleEvent(AddedEdgesEvent e) {
        if (this.networkView.getModel() != e.getSource()) {
            return;
        }
        for (CyEdge edge : e.getPayloadCollection()) {
            View<CyEdge> view = this.networkView.addEdge(edge);
            if (view == null) continue;
            this.eventHelper.addEventPayload((Object)this.networkView, view, AddedEdgeViewsEvent.class);
        }
    }

    public void handleEvent(AboutToRemoveNodesEvent e) {
        if (this.networkView.getModel() != e.getSource()) {
            return;
        }
        for (CyNode node : e.getNodes()) {
            View<CyNode> view = this.networkView.removeNode(node);
            this.eventHelper.addEventPayload((Object)this.networkView, view, AboutToRemoveNodeViewsEvent.class);
        }
    }

    public void handleEvent(AboutToRemoveEdgesEvent e) {
        if (this.networkView.getModel() != e.getSource()) {
            return;
        }
        for (CyEdge edge : e.getEdges()) {
            View<CyEdge> view = this.networkView.removeEdge(edge);
            this.eventHelper.addEventPayload((Object)this.networkView, view, AboutToRemoveEdgeViewsEvent.class);
        }
    }
}

