/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.model.internal.network;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.events.NetworkAboutToBeDestroyedEvent;
import org.cytoscape.model.events.NetworkAboutToBeDestroyedListener;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.events.NetworkViewAboutToBeDestroyedEvent;
import org.cytoscape.view.model.events.NetworkViewAddedEvent;
import org.cytoscape.view.model.events.NetworkViewDestroyedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyNetworkViewManagerImpl
implements CyNetworkViewManager,
NetworkAboutToBeDestroyedListener {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final Map<CyNetwork, Collection<CyNetworkView>> networkViewMap;
    private final Set<CyNetworkView> viewsAboutToBeDestroyed;
    private final CyServiceRegistrar serviceRegistrar;
    private final Object lock = new Object();

    public CyNetworkViewManagerImpl(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.networkViewMap = new WeakHashMap<CyNetwork, Collection<CyNetworkView>>();
        this.viewsAboutToBeDestroyed = new HashSet<CyNetworkView>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.networkViewMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(NetworkAboutToBeDestroyedEvent event) {
        CyNetwork network = event.getNetwork();
        Object object = this.lock;
        synchronized (object) {
            Collection<CyNetworkView> viewList = this.getNetworkViews(network);
            for (CyNetworkView view : viewList) {
                this.destroyNetworkView(view);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CyNetworkView> getNetworkViewSet() {
        LinkedHashSet<CyNetworkView> views = new LinkedHashSet<CyNetworkView>();
        Object object = this.lock;
        synchronized (object) {
            Collection<Collection<CyNetworkView>> vals = this.networkViewMap.values();
            for (Collection<CyNetworkView> setFoViews : vals) {
                views.addAll(setFoViews);
            }
            views.removeAll(this.viewsAboutToBeDestroyed);
        }
        return views;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CyNetworkView> getNetworkViews(CyNetwork network) {
        Object object = this.lock;
        synchronized (object) {
            Collection<CyNetworkView> views = this.networkViewMap.get(network);
            return views != null ? new LinkedHashSet<CyNetworkView>(views) : new LinkedHashSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean viewExists(CyNetwork network) {
        Object object = this.lock;
        synchronized (object) {
            Collection<CyNetworkView> views = this.networkViewMap.get(network);
            return views != null && !views.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyNetworkView(CyNetworkView view) {
        if (view == null) {
            logger.warn("Network view is null.");
            return;
        }
        CyNetwork network = (CyNetwork)view.getModel();
        Object object = this.lock;
        synchronized (object) {
            if (!this.networkViewMap.containsKey(network)) {
                throw new IllegalArgumentException("network view is not recognized by this NetworkManager");
            }
            this.viewsAboutToBeDestroyed.add(view);
        }
        this.fireEvent((CyEvent<?>)new NetworkViewAboutToBeDestroyedEvent((CyNetworkViewManager)this, view));
        object = this.lock;
        synchronized (object) {
            if (!this.networkViewMap.containsKey(network)) {
                throw new IllegalArgumentException("network view is not recognized by this NetworkManager");
            }
            Collection<CyNetworkView> views = this.networkViewMap.get(network);
            views.remove(view);
            this.networkViewMap.put(network, views);
            this.viewsAboutToBeDestroyed.remove(view);
            view.dispose();
        }
        this.fireEvent((CyEvent<?>)new NetworkViewDestroyedEvent((CyNetworkViewManager)this));
        view = null;
    }

    public void addNetworkView(CyNetworkView view) {
        this.addNetworkView(view, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNetworkView(CyNetworkView view, boolean setCurrent) {
        CyApplicationManager applicationManager;
        if (view == null) {
            logger.warn("Network view is null.");
            return;
        }
        CyNetwork network = (CyNetwork)view.getModel();
        CyNetworkManager netMgr = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
        Object object = this.lock;
        synchronized (object) {
            if (!netMgr.networkExists(network.getSUID().longValue())) {
                throw new IllegalArgumentException("Network view cannot be added, because its network (" + network + ") is not registered");
            }
            Collection<CyNetworkView> existingSet = this.networkViewMap.get(network);
            if (existingSet == null) {
                existingSet = new LinkedHashSet<CyNetworkView>();
            }
            existingSet.add(view);
            this.networkViewMap.put(network, existingSet);
        }
        this.fireEvent((CyEvent<?>)new NetworkViewAddedEvent((CyNetworkViewManager)this, view));
        if (setCurrent && (applicationManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)) != null) {
            applicationManager.setCurrentNetworkView(view);
        }
    }

    private void fireEvent(CyEvent<?> event) {
        ((CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class)).fireEvent(event);
    }
}

