/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.model.internal.network;

import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import io.vavr.collection.HashSet;
import io.vavr.collection.Map;
import io.vavr.collection.Seq;
import io.vavr.collection.Set;
import io.vavr.collection.Traversable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewListener;
import org.cytoscape.view.model.CyNetworkViewSnapshot;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.model.events.AddedEdgeViewsEvent;
import org.cytoscape.view.model.events.AddedNodeViewsEvent;
import org.cytoscape.view.model.events.UpdateNetworkPresentationEvent;
import org.cytoscape.view.model.events.ViewChangeRecord;
import org.cytoscape.view.model.events.ViewChangedEvent;
import org.cytoscape.view.model.internal.base.CyViewBase;
import org.cytoscape.view.model.internal.base.VPStore;
import org.cytoscape.view.model.internal.base.ViewLock;
import org.cytoscape.view.model.internal.network.CyEdgeViewImpl;
import org.cytoscape.view.model.internal.network.CyNetworkViewFactoryConfigImpl;
import org.cytoscape.view.model.internal.network.CyNodeViewImpl;
import org.cytoscape.view.model.internal.network.VPEdgeStore;
import org.cytoscape.view.model.internal.network.VPNetworkStore;
import org.cytoscape.view.model.internal.network.VPNodeStore;
import org.cytoscape.view.model.internal.network.snapshot.CyNetworkViewSnapshotImpl;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;

public class CyNetworkViewImpl
extends CyViewBase<CyNetwork>
implements CyNetworkView {
    public static final Set<VisualProperty<?>> NODE_GEOMETRIC_PROPS = HashSet.of((Object[])new VisualProperty[]{BasicVisualLexicon.NODE_X_LOCATION, BasicVisualLexicon.NODE_Y_LOCATION, BasicVisualLexicon.NODE_HEIGHT, BasicVisualLexicon.NODE_WIDTH, BasicVisualLexicon.NODE_VISIBLE});
    private final CyEventHelper eventHelper;
    private final String rendererId;
    private final VisualLexicon visualLexicon;
    private final boolean isBVL;
    private CopyOnWriteArrayList<CyNetworkViewListener> listeners = new CopyOnWriteArrayList();
    private boolean dirty = true;
    private Map<Long, CyNodeViewImpl> dataSuidToNode = HashMap.empty();
    private Map<Long, CyNodeViewImpl> viewSuidToNode = HashMap.empty();
    private Map<Long, CyEdgeViewImpl> dataSuidToEdge = HashMap.empty();
    private Map<Long, CyEdgeViewImpl> viewSuidToEdge = HashMap.empty();
    private Map<Long, Set<CyEdgeViewImpl>> adjacentEdgeMap = HashMap.empty();
    protected final ViewLock netLock;
    protected final ViewLock nodeLock;
    protected final ViewLock edgeLock;
    protected final VPNodeStore nodeVPs;
    protected final VPEdgeStore edgeVPs;
    protected final VPNetworkStore netVPs;
    private boolean isNeverHidden = true;

    public CyNetworkViewImpl(CyServiceRegistrar registrar, CyNetwork network, VisualLexicon visualLexicon, String rendererId, CyNetworkViewFactoryConfigImpl config) {
        super(network);
        this.eventHelper = (CyEventHelper)registrar.getService(CyEventHelper.class);
        this.rendererId = rendererId;
        this.visualLexicon = visualLexicon;
        this.isBVL = visualLexicon instanceof BasicVisualLexicon;
        this.netLock = new ViewLock();
        this.nodeLock = new ViewLock(this.netLock);
        this.edgeLock = new ViewLock(this.netLock);
        this.edgeVPs = new VPEdgeStore(visualLexicon, config);
        this.nodeVPs = new VPNodeStore(visualLexicon, config);
        this.netVPs = new VPNetworkStore(visualLexicon, config);
    }

    public boolean supportsSnapshots() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CyNetworkViewSnapshot createSnapshot() {
        ViewLock viewLock = this.nodeLock;
        synchronized (viewLock) {
            ViewLock viewLock2 = this.edgeLock;
            synchronized (viewLock2) {
                ViewLock viewLock3 = this.netLock;
                synchronized (viewLock3) {
                    return new CyNetworkViewSnapshotImpl(this, this.rendererId, this.dataSuidToNode, this.viewSuidToNode, this.dataSuidToEdge, this.viewSuidToEdge, this.adjacentEdgeMap, this.nodeVPs.createSnapshot(), this.edgeVPs.createSnapshot(), this.netVPs.createSnapshot(), this.visualLexicon);
                }
            }
        }
    }

    public boolean isBVL() {
        return this.isBVL;
    }

    public synchronized boolean dirty(boolean clear) {
        boolean d = this.dirty;
        if (clear) {
            this.dirty = false;
        }
        return d;
    }

    @Override
    public VPStore getVPStore() {
        return this.netVPs;
    }

    @Override
    public ViewLock getLock() {
        return this.netLock;
    }

    @Override
    public void setDirty() {
        this.dirty = true;
    }

    public CyEventHelper getEventHelper() {
        return this.eventHelper;
    }

    @Override
    public VisualLexicon getVisualLexicon() {
        return this.visualLexicon;
    }

    public boolean isNeverHidden() {
        return this.isNeverHidden;
    }

    public void setElementHidden() {
        this.isNeverHidden = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CyNodeViewImpl addNode(CyNode model) {
        CyNodeViewImpl view;
        ViewLock viewLock = this.nodeLock;
        synchronized (viewLock) {
            if (this.dataSuidToNode.containsKey((Object)model.getSUID())) {
                return null;
            }
            view = new CyNodeViewImpl(this, model);
            this.dataSuidToNode = this.dataSuidToNode.put((Object)model.getSUID(), (Object)view);
            this.viewSuidToNode = this.viewSuidToNode.put((Object)view.getSUID(), (Object)view);
            this.setDirty();
        }
        this.eventHelper.addEventPayload((Object)this, (Object)view, AddedNodeViewsEvent.class);
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View<CyEdge> addEdge(CyEdge edge) {
        CyEdgeViewImpl view;
        CyNode source = edge.getSource();
        CyNode target = edge.getTarget();
        CyNodeViewImpl sourceView = (CyNodeViewImpl)this.dataSuidToNode.getOrElse((Object)source.getSUID(), null);
        CyNodeViewImpl targetView = (CyNodeViewImpl)this.dataSuidToNode.getOrElse((Object)target.getSUID(), null);
        if (sourceView == null || targetView == null) {
            this.addNode(source);
            this.addNode(target);
            sourceView = (CyNodeViewImpl)this.dataSuidToNode.getOrElse((Object)source.getSUID(), null);
            targetView = (CyNodeViewImpl)this.dataSuidToNode.getOrElse((Object)target.getSUID(), null);
        }
        ViewLock viewLock = this.edgeLock;
        synchronized (viewLock) {
            if (this.dataSuidToEdge.containsKey((Object)edge.getSUID())) {
                return null;
            }
            view = new CyEdgeViewImpl(this, edge, sourceView.getSUID(), targetView.getSUID());
            this.dataSuidToEdge = this.dataSuidToEdge.put((Object)edge.getSUID(), (Object)view);
            this.viewSuidToEdge = this.viewSuidToEdge.put((Object)view.getSUID(), (Object)view);
            this.updateAdjacentEdgeMap(view, true);
            this.setDirty();
        }
        this.eventHelper.addEventPayload((Object)this, (Object)view, AddedEdgeViewsEvent.class);
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View<CyNode> removeNode(CyNode model) {
        ViewLock viewLock = this.nodeLock;
        synchronized (viewLock) {
            ViewLock viewLock2 = this.edgeLock;
            synchronized (viewLock2) {
                View nodeView = (View)this.dataSuidToNode.getOrElse((Object)model.getSUID(), null);
                if (nodeView != null) {
                    this.dataSuidToNode = this.dataSuidToNode.remove((Object)model.getSUID());
                    this.viewSuidToNode = this.viewSuidToNode.remove((Object)nodeView.getSUID());
                    Set adjacentEdges = (Set)this.adjacentEdgeMap.getOrElse((Object)nodeView.getSUID(), (Object)HashSet.empty());
                    for (CyEdgeViewImpl adjacentEdge : adjacentEdges) {
                        this.removeEdge((CyEdge)adjacentEdge.getModel());
                    }
                    this.adjacentEdgeMap = this.adjacentEdgeMap.remove((Object)nodeView.getSUID());
                    this.nodeVPs.remove(nodeView.getSUID());
                    this.setDirty();
                }
                return nodeView;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View<CyEdge> removeEdge(CyEdge model) {
        ViewLock viewLock = this.edgeLock;
        synchronized (viewLock) {
            CyEdgeViewImpl edgeView = (CyEdgeViewImpl)this.dataSuidToEdge.getOrElse((Object)model.getSUID(), null);
            if (edgeView != null) {
                this.dataSuidToEdge = this.dataSuidToEdge.remove((Object)model.getSUID());
                this.viewSuidToEdge = this.viewSuidToEdge.remove((Object)edgeView.getSUID());
                this.updateAdjacentEdgeMap(edgeView, false);
                this.edgeVPs.remove(edgeView.getSUID());
                this.setDirty();
            }
            return edgeView;
        }
    }

    public View<CyNode> getNodeView(CyNode node) {
        return (View)this.dataSuidToNode.getOrElse((Object)node.getSUID(), null);
    }

    public View<CyNode> getNodeView(long suid) {
        return (View)this.viewSuidToNode.getOrElse((Object)suid, null);
    }

    public View<CyNode> getNodeViewByDataSuid(Long suid) {
        return (View)this.dataSuidToNode.getOrElse((Object)suid, null);
    }

    public View<CyEdge> getEdgeView(CyEdge edge) {
        return (View)this.dataSuidToEdge.getOrElse((Object)edge.getSUID(), null);
    }

    public CyEdgeViewImpl getEdgeView(long suid) {
        return (CyEdgeViewImpl)this.viewSuidToEdge.getOrElse((Object)suid, null);
    }

    public View<CyEdge> getEdgeViewByDataSuid(Long suid) {
        return (View)this.dataSuidToEdge.getOrElse((Object)suid, null);
    }

    public Collection<View<CyNode>> getNodeViews() {
        ArrayList<View<CyNode>> nodeList = new ArrayList<View<CyNode>>();
        for (CyNodeViewImpl node : this.dataSuidToNode.values()) {
            nodeList.add(node);
        }
        return nodeList;
    }

    public Iterable<View<CyNode>> getNodeViewsIterable() {
        Seq traversable = this.dataSuidToNode.values();
        return new Iterable<View<CyNode>>((Traversable)traversable){
            final /* synthetic */ Traversable val$traversable;
            {
                this.val$traversable = traversable;
            }

            @Override
            public Iterator<View<CyNode>> iterator() {
                return new TraversableIterator<View<CyNode>>(this.val$traversable);
            }
        };
    }

    public Collection<View<CyEdge>> getEdgeViews() {
        ArrayList<View<CyEdge>> edgeList = new ArrayList<View<CyEdge>>();
        for (CyEdgeViewImpl edge : this.dataSuidToEdge.values()) {
            edgeList.add(edge);
        }
        return edgeList;
    }

    public Iterable<View<CyEdge>> getEdgeViewsIterable() {
        Seq traversable = this.dataSuidToEdge.values();
        return new Iterable<View<CyEdge>>((Traversable)traversable){
            final /* synthetic */ Traversable val$traversable;
            {
                this.val$traversable = traversable;
            }

            @Override
            public Iterator<View<CyEdge>> iterator() {
                return new TraversableIterator<View<CyEdge>>(this.val$traversable);
            }
        };
    }

    public Collection<View<? extends CyIdentifiable>> getAllViews() {
        ArrayList<View<? extends CyIdentifiable>> list = new ArrayList<View<? extends CyIdentifiable>>();
        list.addAll(this.getNodeViews());
        list.addAll(this.getEdgeViews());
        list.add(this);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAdjacentEdgeMap(CyEdgeViewImpl edgeView, boolean add) {
        ViewLock viewLock = this.edgeLock;
        synchronized (viewLock) {
            Set edges = (Set)this.adjacentEdgeMap.getOrElse((Object)edgeView.getSourceSuid(), (Object)HashSet.empty());
            edges = add ? edges.add((Object)edgeView) : edges.remove((Object)edgeView);
            this.adjacentEdgeMap = this.adjacentEdgeMap.put((Object)edgeView.getSourceSuid(), (Object)edges);
            edges = (Set)this.adjacentEdgeMap.getOrElse((Object)edgeView.getTargetSuid(), (Object)HashSet.empty());
            edges = add ? edges.add((Object)edgeView) : edges.remove((Object)edgeView);
            this.adjacentEdgeMap = this.adjacentEdgeMap.put((Object)edgeView.getTargetSuid(), (Object)edges);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, V extends T> void setViewDefault(VisualProperty<? extends T> vp, V defaultValue) {
        if (vp.shouldIgnoreDefault()) {
            return;
        }
        if (vp.getTargetDataType().equals(CyNode.class)) {
            ViewLock viewLock = this.nodeLock;
            synchronized (viewLock) {
                this.nodeVPs.setViewDefault(vp, defaultValue);
                if (this.nodeVPs.getConfig().isTracked(vp)) {
                    this.netVPs.updateTrackedVP(this.getSUID(), vp);
                }
            }
        }
        if (vp.getTargetDataType().equals(CyEdge.class)) {
            ViewLock viewLock = this.edgeLock;
            synchronized (viewLock) {
                this.edgeVPs.setViewDefault(vp, defaultValue);
                if (this.edgeVPs.getConfig().isTracked(vp)) {
                    for (Tuple2 t : this.viewSuidToEdge) {
                        this.edgeVPs.updateTrackedVP((Long)t._1, vp);
                    }
                }
                if (vp == BasicVisualLexicon.EDGE_STROKE_SELECTED_PAINT) {
                    this.setViewDefault(BasicVisualLexicon.EDGE_SELECTED_PAINT, defaultValue);
                } else if (vp == BasicVisualLexicon.EDGE_STROKE_UNSELECTED_PAINT) {
                    this.setViewDefault(BasicVisualLexicon.EDGE_UNSELECTED_PAINT, defaultValue);
                }
            }
        }
        if (vp.getTargetDataType().equals(CyNetwork.class)) {
            ViewLock viewLock = this.netLock;
            synchronized (viewLock) {
                this.netVPs.setViewDefault(vp, defaultValue);
                if (this.netVPs.getConfig().isTracked(vp)) {
                    for (Tuple2 t : this.viewSuidToNode) {
                        this.nodeVPs.updateTrackedVP((Long)t._1, vp);
                    }
                }
            }
        }
        this.setDirty();
    }

    public String getRendererId() {
        return this.rendererId;
    }

    public void addNetworkViewListener(CyNetworkViewListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeNetworkViewListener(CyNetworkViewListener listener) {
        this.listeners.remove(listener);
    }

    public void fitContent() {
        for (CyNetworkViewListener listener : this.listeners) {
            listener.handleFitContent();
        }
        this.setDirty();
    }

    public void fitSelected() {
        for (CyNetworkViewListener listener : this.listeners) {
            listener.handleFitSelected();
        }
        this.setDirty();
    }

    public void updateView() {
        this.eventHelper.fireEvent((CyEvent)new UpdateNetworkPresentationEvent((CyNetworkView)this));
        for (CyNetworkViewListener listener : this.listeners) {
            listener.handleUpdateView();
        }
        this.setDirty();
    }

    public void dispose() {
        for (CyNetworkViewListener listener : this.listeners) {
            listener.handleDispose();
        }
    }

    @Override
    protected void fireViewChangedEvent(VisualProperty<?> vp, Object value, boolean lockedValue) {
        ViewChangeRecord record = new ViewChangeRecord((View)this, vp, value, lockedValue);
        this.getEventHelper().addEventPayload((Object)this, (Object)record, ViewChangedEvent.class);
    }

    private static class TraversableIterator<T>
    implements Iterator<T> {
        private Traversable<? extends T> traversable;

        TraversableIterator(Traversable<? extends T> traversable) {
            this.traversable = traversable;
        }

        @Override
        public boolean hasNext() {
            return !this.traversable.isEmpty();
        }

        @Override
        public T next() {
            Object element = this.traversable.head();
            this.traversable = this.traversable.tail();
            return (T)element;
        }
    }
}

