/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.model.internal.network;

import java.util.Properties;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.view.model.CyNetworkViewListener;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.internal.network.CyNetworkViewFactoryConfigImpl;
import org.cytoscape.view.model.internal.network.CyNetworkViewImpl;
import org.cytoscape.view.model.internal.network.NetworkModelListener;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;

public class CyNetworkViewFactoryImpl
implements CyNetworkViewFactory {
    private final CyServiceRegistrar registrar;
    private final VisualLexicon visualLexicon;
    private final String rendererId;
    private final CyNetworkViewFactoryConfigImpl config;

    public CyNetworkViewFactoryImpl(CyServiceRegistrar registrar, VisualLexicon visualLexicon, String rendererId, CyNetworkViewFactoryConfigImpl config) {
        this.registrar = registrar;
        this.visualLexicon = visualLexicon;
        this.rendererId = rendererId;
        this.config = config;
    }

    public CyNetworkView createNetworkView(CyNetwork network) {
        CyNetworkViewImpl networkView = this.createNetworkViewImpl(network);
        this.listenForModelChanges(networkView);
        return networkView;
    }

    private CyNetworkViewImpl createNetworkViewImpl(CyNetwork network) {
        Boolean selected;
        CyRow row;
        View<CyEdge> view;
        CyNetworkViewImpl networkViewImpl = new CyNetworkViewImpl(this.registrar, network, this.visualLexicon, this.rendererId, this.config);
        for (CyNode node : network.getNodeList()) {
            view = networkViewImpl.addNode(node);
            row = network.getDefaultNodeTable().getRow((Object)node.getSUID());
            selected = (Boolean)row.get("selected", Boolean.class);
            view.setVisualProperty(BasicVisualLexicon.NODE_SELECTED, (Object)selected);
        }
        for (CyEdge edge : network.getEdgeList()) {
            view = networkViewImpl.addEdge(edge);
            if (view == null) continue;
            row = network.getDefaultEdgeTable().getRow((Object)edge.getSUID());
            selected = (Boolean)row.get("selected", Boolean.class);
            view.setVisualProperty(BasicVisualLexicon.EDGE_SELECTED, (Object)selected);
        }
        return networkViewImpl;
    }

    private void listenForModelChanges(CyNetworkViewImpl networkView) {
        final NetworkModelListener modelListener = new NetworkModelListener(networkView, this.registrar);
        networkView.addNetworkViewListener(new CyNetworkViewListener(){

            public void handleDispose() {
                CyNetworkViewFactoryImpl.this.registrar.unregisterAllServices((Object)modelListener);
            }
        });
        this.registrar.registerAllServices((Object)modelListener, new Properties());
    }
}

