/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.websession;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.cytoscape.application.CyApplicationConfiguration;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.internal.write.json.CytoscapeJsNetworkWriterFactory;
import org.cytoscape.io.internal.write.websession.WebSessionWriterImpl;
import org.cytoscape.io.write.VizmapWriterFactory;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.TaskMonitor;

public class SimpleWebSessionWriterImpl
extends WebSessionWriterImpl {
    private final CyApplicationManager applicationManager;
    private Path resourceFilePath;
    private VisualMappingManager vmm;

    public SimpleWebSessionWriterImpl(OutputStream outputStream, String exportType, VizmapWriterFactory jsonStyleWriterFactory, VisualMappingManager vmm, CytoscapeJsNetworkWriterFactory cytoscapejsWriterFactory, CyNetworkViewManager viewManager, CyApplicationConfiguration appConfig, CyApplicationManager applicationManager) {
        super(outputStream, exportType, jsonStyleWriterFactory, vmm, cytoscapejsWriterFactory, viewManager, appConfig);
        this.applicationManager = applicationManager;
        this.vmm = vmm;
    }

    @Override
    public void writeFiles(TaskMonitor tm) throws Exception {
        tm.setProgress(0.1);
        tm.setStatusMessage("Saving networks as Cytoscape.js JS...");
        CyNetworkView view = this.applicationManager.getCurrentNetworkView();
        if (view == null) {
            return;
        }
        HashSet<CyNetworkView> viewSet = new HashSet<CyNetworkView>();
        viewSet.add(view);
        File file = this.createNetworkViewFile(viewSet);
        ArrayList<File> files = new ArrayList<File>();
        files.add(file);
        if (viewSet.size() != 1) {
            throw new IllegalStateException("Simple Web Session Writer takes only one network view.");
        }
        tm.setProgress(0.7);
        if (this.cancelled) {
            return;
        }
        tm.setStatusMessage("Saving Visual Styles as JS...");
        HashSet<VisualStyle> styles = new HashSet<VisualStyle>();
        styles.add(this.vmm.getCurrentVisualStyle());
        File styleFile = this.createStyleFile(tm, styles);
        files.add(styleFile);
        tm.setProgress(0.9);
        this.resourceFilePath = Paths.get(this.webResourceDirectory.getAbsolutePath(), "web", this.exportType);
        files.add(this.resourceFilePath.toFile());
        this.zipAll(files);
        if (this.cancelled) {
            return;
        }
        tm.setStatusMessage("Done.");
        tm.setProgress(1.0);
    }

    private final void zipAll(Collection<File> files) throws IOException {
        this.zos = new ZipOutputStream(this.outputStream);
        this.addDir(files.toArray(new File[0]), this.zos);
        this.zos.close();
    }

    private void addDir(File[] files, ZipOutputStream out) throws IOException {
        byte[] buffer = new byte[4096];
        for (File file : files) {
            int len;
            if (file.isDirectory()) {
                this.addDir(file.listFiles(), out);
                continue;
            }
            FileInputStream in = new FileInputStream(file);
            Path filePath = file.toPath();
            String zipFilePath = null;
            if (!file.getAbsolutePath().contains(this.resourceFilePath.toString())) {
                String currentFileName = file.getName();
                String fileName = currentFileName.startsWith("style") ? "styles.js" : "networks.js";
                Path dataFilePath = Paths.get("web_session", fileName);
                zipFilePath = dataFilePath.toString();
            } else {
                Path relPath = this.resourceFilePath.relativize(filePath);
                Path newResourceFilePath = Paths.get("web_session", relPath.toString());
                zipFilePath = newResourceFilePath.toString();
            }
            if (File.separatorChar != '/') {
                zipFilePath = zipFilePath.replace('\\', '/');
            }
            ZipEntry entry = new ZipEntry(zipFilePath);
            out.putNextEntry(entry);
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            out.closeEntry();
            in.close();
        }
    }
}

