/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.json.serializer;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cytoscape.io.internal.write.json.serializer.CytoscapeJsToken;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;

public class JsRowSerializer
extends JsonSerializer<CyRow> {
    private static final Pattern REPLACE_INVALID_JS_CHAR_PATTERN = Pattern.compile("^[^a-zA-Z_]+|[^a-zA-Z_0-9]+");

    public void serialize(CyRow row, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        CyTable table = row.getTable();
        Map values = row.getAllValues();
        for (String columnName : values.keySet()) {
            Object value = values.get(columnName);
            if (value == null) continue;
            Class type = table.getColumn(columnName).getType();
            if (type == List.class) {
                type = table.getColumn(columnName).getListElementType();
                this.writeList(type, columnName, (List)value, jgen);
                continue;
            }
            jgen.writeFieldName(this.replaceColumnName(columnName));
            this.writeValue(type, value, jgen);
        }
    }

    private void writeList(Class<?> type, String columnName, List<?> values, JsonGenerator jgen) throws JsonGenerationException, IOException {
        jgen.writeFieldName(this.replaceColumnName(columnName));
        jgen.writeStartArray();
        for (Object value : values) {
            this.writeValue(type, value, jgen);
        }
        jgen.writeEndArray();
    }

    private final String replaceColumnName(String columnName) {
        if (columnName.equals(CytoscapeJsToken.ID.getTag()) || columnName.equals(CytoscapeJsToken.SOURCE.getTag()) || columnName.equals(CytoscapeJsToken.TARGET.getTag())) {
            return columnName + "_original";
        }
        Matcher matcher = REPLACE_INVALID_JS_CHAR_PATTERN.matcher(columnName);
        return matcher.replaceAll("_");
    }

    private final void writeValue(Class<?> type, Object value, JsonGenerator jgen) throws JsonGenerationException, IOException {
        if (type == String.class) {
            jgen.writeString(value.toString());
        } else if (type == Boolean.class) {
            jgen.writeBoolean(((Boolean)value).booleanValue());
        } else if (type == Double.class) {
            jgen.writeNumber(((Double)value).doubleValue());
        } else if (type == Integer.class) {
            jgen.writeNumber(((Integer)value).intValue());
        } else if (type == Long.class) {
            jgen.writeNumber(((Long)value).longValue());
        } else if (type == Float.class) {
            jgen.writeNumber(((Double)value).doubleValue());
        }
    }

    public Class<CyRow> handledType() {
        return CyRow.class;
    }
}

