/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.json.serializer;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.awt.Font;
import java.io.IOException;

public class FontFaceSerializer
extends JsonSerializer<Font> {
    public void serialize(Font value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        if (value == null) {
            jgen.writeString("SansSerif");
        } else {
            jgen.writeString(value.getFontName());
            this.writeFontWeight(value, jgen);
        }
    }

    private final void writeFontWeight(Font font, JsonGenerator jgen) throws JsonGenerationException, IOException {
        int style = font.getStyle();
        if (style == 1) {
            jgen.writeStringField("font-weight", "bold");
        } else {
            jgen.writeStringField("font-weight", "normal");
        }
    }

    public Class<Font> handledType() {
        return Font.class;
    }
}

