/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.json.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.List;
import org.cytoscape.application.CyVersion;
import org.cytoscape.io.internal.write.json.serializer.CytoscapeJsToken;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.CyNetworkView;

public class CytoscapeJsViewSerializer
extends JsonSerializer<CyNetworkView> {
    private final String version;

    public CytoscapeJsViewSerializer(CyVersion cyVersion) {
        this.version = cyVersion.getVersion();
    }

    public void serialize(CyNetworkView networkView, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        jgen.useDefaultPrettyPrinter();
        jgen.writeStartObject();
        jgen.writeStringField("format_version", "1.0");
        jgen.writeStringField("generated_by", "cytoscape-" + this.version);
        jgen.writeStringField("target_cytoscapejs_version", "~2.1");
        CyNetwork network = (CyNetwork)networkView.getModel();
        jgen.writeObjectFieldStart(CytoscapeJsToken.DATA.getTag());
        jgen.writeObject((Object)network.getRow((CyIdentifiable)network));
        jgen.writeEndObject();
        jgen.writeObjectFieldStart(CytoscapeJsToken.ELEMENTS.getTag());
        List nodes = network.getNodeList();
        List edges = network.getEdgeList();
        jgen.writeArrayFieldStart(CytoscapeJsToken.NODES.getTag());
        for (CyNode node : nodes) {
            jgen.writeStartObject();
            jgen.writeObjectFieldStart(CytoscapeJsToken.DATA.getTag());
            jgen.writeStringField(CytoscapeJsToken.ID.getTag(), node.getSUID().toString());
            jgen.writeObject((Object)network.getRow((CyIdentifiable)node));
            jgen.writeEndObject();
            jgen.writeObject((Object)networkView.getNodeView(node));
            jgen.writeBooleanField("selected", ((Boolean)network.getRow((CyIdentifiable)node).get("selected", Boolean.class)).booleanValue());
            jgen.writeEndObject();
        }
        jgen.writeEndArray();
        jgen.writeArrayFieldStart(CytoscapeJsToken.EDGES.getTag());
        for (CyEdge edge : edges) {
            jgen.writeStartObject();
            jgen.writeObjectFieldStart(CytoscapeJsToken.DATA.getTag());
            jgen.writeStringField(CytoscapeJsToken.ID.getTag(), edge.getSUID().toString());
            jgen.writeStringField(CytoscapeJsToken.SOURCE.getTag(), edge.getSource().getSUID().toString());
            jgen.writeStringField(CytoscapeJsToken.TARGET.getTag(), edge.getTarget().getSUID().toString());
            jgen.writeObject((Object)network.getRow((CyIdentifiable)edge));
            jgen.writeEndObject();
            jgen.writeBooleanField("selected", ((Boolean)network.getRow((CyIdentifiable)edge).get("selected", Boolean.class)).booleanValue());
            jgen.writeEndObject();
        }
        jgen.writeEndArray();
        jgen.writeEndObject();
    }

    public Class<CyNetworkView> handledType() {
        return CyNetworkView.class;
    }
}

