/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.json.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;

public class ColorSerializer
extends JsonSerializer<Paint> {
    private static final Color DEF_COLOR = Color.WHITE;

    public void serialize(Paint value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        if (!(value instanceof Color) || value == null) {
            jgen.writeString(this.decodeColor(DEF_COLOR));
            return;
        }
        jgen.writeString(this.decodeColor((Color)value));
    }

    private final String decodeColor(Color color) {
        StringBuilder builder = new StringBuilder();
        builder.append("rgb(");
        builder.append(color.getRed() + ",");
        builder.append(color.getGreen() + ",");
        builder.append(color.getBlue() + ")");
        return builder.toString();
    }

    public Class<Paint> handledType() {
        return Paint.class;
    }
}

