/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.cytoscape.io.internal.write.json.EncodingUtil;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.task.AbstractNetworkViewTask;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.TaskMonitor;

public final class JSONNetworkViewWriter
extends AbstractNetworkViewTask
implements CyWriter {
    final OutputStream outputStream;
    protected final ObjectMapper networkView2jsonMapper;

    public JSONNetworkViewWriter(OutputStream outputStream, CyNetworkView networkView, ObjectMapper networkView2jsonMapper) {
        super(networkView);
        if (outputStream == null) {
            throw new NullPointerException("Output Stream is null.");
        }
        if (networkView2jsonMapper == null) {
            throw new NullPointerException("Object Mapper is null.");
        }
        this.outputStream = outputStream;
        this.networkView2jsonMapper = networkView2jsonMapper;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        if (taskMonitor != null) {
            taskMonitor.setTitle("Writing Network View to JSON...");
            taskMonitor.setProgress(0.0);
        }
        OutputStreamWriter writer = new OutputStreamWriter(this.outputStream, EncodingUtil.getEncoder());
        this.networkView2jsonMapper.writeValue((Writer)writer, (Object)this.view);
    }
}

