/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.view;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.cytoscape.filter.TransformerManager;
import org.cytoscape.filter.internal.FilterIO;
import org.cytoscape.filter.internal.ModelUtil;
import org.cytoscape.filter.internal.filters.composite.CompositeFilterController;
import org.cytoscape.filter.internal.filters.composite.CompositeFilterPanel;
import org.cytoscape.filter.internal.filters.composite.CompositeSeparator;
import org.cytoscape.filter.internal.filters.composite.CompositeTransformerPanel;
import org.cytoscape.filter.internal.view.AbstractPanelController;
import org.cytoscape.filter.internal.view.DynamicComboBoxModel;
import org.cytoscape.filter.internal.view.FilterElement;
import org.cytoscape.filter.internal.view.FilterPanelController;
import org.cytoscape.filter.internal.view.NamedElementListener;
import org.cytoscape.filter.internal.view.TransformerElement;
import org.cytoscape.filter.internal.view.TransformerPanel;
import org.cytoscape.filter.internal.view.TransformerViewManager;
import org.cytoscape.filter.internal.view.look.FilterPanelStyle;
import org.cytoscape.filter.internal.work.TransformerWorker;
import org.cytoscape.filter.internal.work.ValidationManager;
import org.cytoscape.filter.model.CompositeFilter;
import org.cytoscape.filter.model.Filter;
import org.cytoscape.filter.model.NamedTransformer;
import org.cytoscape.filter.model.SubFilterTransformer;
import org.cytoscape.filter.model.Transformer;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;

public class TransformerPanelController
extends AbstractPanelController<TransformerElement, TransformerPanel> {
    private TransformerManager transformerManager;
    private TransformerViewManager transformerViewManager;
    private DynamicComboBoxModel<FilterElement> startWithComboBoxModel;

    public TransformerPanelController(TransformerManager transformerManager, TransformerViewManager transformerViewManager, ValidationManager validationManager, FilterPanelController filterPanelController, TransformerWorker worker, FilterIO filterIo, FilterPanelStyle style, CyServiceRegistrar serviceRegistrar) {
        super(worker, transformerManager, transformerViewManager, validationManager, filterIo, style, serviceRegistrar);
        worker.setController(this);
        this.transformerManager = transformerManager;
        this.transformerViewManager = transformerViewManager;
        ArrayList<FilterElement> items = new ArrayList<FilterElement>();
        items.add(new FilterElement("Current Selection", null));
        this.startWithComboBoxModel = new DynamicComboBoxModel(items);
        filterPanelController.addNamedElementListener(new NamedElementListener<FilterElement>(){

            @Override
            public void handleElementRemoved(FilterElement element) {
                TransformerPanelController.this.startWithComboBoxModel.remove(element);
            }

            @Override
            public void handleElementAdded(FilterElement element) {
                if (element.getFilter() == null) {
                    return;
                }
                TransformerPanelController.this.startWithComboBoxModel.add(element);
            }
        });
        this.addNewElement("Default chain");
    }

    @Override
    protected void handleElementSelected(TransformerElement selected, TransformerPanel panel) {
        CompositeTransformerPanel root = new CompositeTransformerPanel(panel, this, selected.getChain(), this.serviceRegistrar);
        panel.setRootPanel(root);
    }

    @Override
    protected void synchronize(TransformerPanel panel) {
    }

    @Override
    protected TransformerElement createElement(String name) {
        ArrayList<Transformer<CyNetwork, CyIdentifiable>> chain = new ArrayList<Transformer<CyNetwork, CyIdentifiable>>();
        return new TransformerElement(name, chain);
    }

    @Override
    protected String getPrompt() {
        return "Please provide a name for your filter chain.";
    }

    @Override
    protected String getCreateElementTitle() {
        return "Create New Filter Chain";
    }

    @Override
    protected String getRenameElementTitle() {
        return "Rename Filter Chain";
    }

    @Override
    protected String getElementTemplate() {
        return "My chain %1$d";
    }

    @Override
    protected String getElementExistsWarningTemplate() {
        return "The name '%1$s' is already being used by another filter chain.  Please provide a different name.";
    }

    @Override
    protected String getCreateMenuLabel() {
        return "New filter chain";
    }

    @Override
    protected String getDeleteMenuLabel() {
        return "Remove current filter chain";
    }

    @Override
    protected String getRenameMenuLabel() {
        return "Rename current filter chain";
    }

    @Override
    protected String getCopyMenuLabel() {
        return "Copy current filter chain";
    }

    @Override
    protected String getExportLabel() {
        return "Export filter chains...";
    }

    @Override
    protected String getImportLabel() {
        return "Import filter chains...";
    }

    @Override
    public String getHandleToolTip() {
        return "Drag this chain entry to reorder.";
    }

    public JPopupMenu createAddChainEntryMenu(final CompositeTransformerPanel panel, final TransformerPanel transformerPanel) {
        JPopupMenu menu = new JPopupMenu();
        for (final TransformerViewManager.TransformerViewElement element : this.transformerViewManager.getChainTransformerViewElements()) {
            JMenuItem mi = new JMenuItem(element.toString());
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TransformerPanelController.this.handleAddTransformer(element, panel, transformerPanel);
                }
            });
            menu.add(mi);
        }
        return menu;
    }

    public ComboBoxModel getStartWithComboBoxModel() {
        return this.startWithComboBoxModel;
    }

    private void handleAddTransformer(TransformerViewManager.TransformerViewElement element, CompositeTransformerPanel panel, TransformerPanel transformerPanel) {
        Transformer transformer = this.transformerManager.createTransformer(element.getId());
        panel.addTransformer((Transformer<CyNetwork, CyIdentifiable>)transformer);
        panel.updateLayout();
    }

    @Override
    public JComponent createView(TransformerPanel parent, Transformer<CyNetwork, CyIdentifiable> transformer, int depth) {
        JComponent view = this.transformerViewManager.createView(transformer);
        if (transformer instanceof SubFilterTransformer || transformer instanceof CompositeFilter) {
            String addButtonTT = this.transformerViewManager.getAddButtonTooltip(transformer);
            CompositeFilterController controller = CompositeFilterController.createFor(view, addButtonTT);
            CompositeFilter compositeFilter = transformer instanceof SubFilterTransformer ? ((SubFilterTransformer)transformer).getCompositeFilter() : (CompositeFilter)transformer;
            return new CompositeFilterPanel<TransformerPanel>(parent, this, controller, (CompositeFilter<CyNetwork, CyIdentifiable>)compositeFilter, depth);
        }
        if (view == null) {
            throw new IllegalArgumentException("view could not be created for: " + transformer.getId());
        }
        return view;
    }

    public void handleApply(TransformerPanel transformerPanel) {
        this.worker.requestWork();
    }

    public List<Transformer<CyNetwork, CyIdentifiable>> getTransformers(TransformerPanel panel) {
        CompositeTransformerPanel root = panel.getRootPanel();
        return root.getModel();
    }

    @Override
    public void addNamedTransformer(TransformerPanel panel, NamedTransformer<CyNetwork, CyIdentifiable> namedTransformer, boolean strictName) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(() -> this.addNamedTransformer(panel, namedTransformer, strictName));
            }
            catch (InterruptedException e) {
                this.logger.error("An unexpected error occurred", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                this.logger.error("An unexpected error occurred", (Throwable)e);
            }
            return;
        }
        int validated = 0;
        for (Transformer transformer : namedTransformer.getTransformers()) {
            if (transformer instanceof Filter) continue;
            ++validated;
        }
        if (validated == 0) {
            return;
        }
        String name = strictName ? namedTransformer.getName() : this.findUniqueName(namedTransformer.getName());
        if (this.getElementByName(name) != null) {
            throw new IllegalArgumentException("Transformer with name '" + name + "' already exists.");
        }
        TransformerElement element = (TransformerElement)this.addNewElement(name);
        for (Transformer transformer : namedTransformer.getTransformers()) {
            if (transformer instanceof Filter) continue;
            element.getChain().add((Transformer<CyNetwork, CyIdentifiable>)transformer);
        }
        TransformerElement selected = (TransformerElement)this.namedElementComboBoxModel.getSelectedItem();
        if (selected == null) {
            return;
        }
        this.handleElementSelected(selected, panel);
    }

    @Override
    public NamedTransformer<CyNetwork, CyIdentifiable>[] getNamedTransformers() {
        DynamicComboBoxModel model = this.getElementComboBoxModel();
        NamedTransformer[] namedTransformers = new NamedTransformer[model.getSize()];
        int i = 0;
        for (TransformerElement element : model) {
            if (element.getChain() == null) continue;
            namedTransformers[i] = this.toNamedController(element);
            ++i;
        }
        return namedTransformers;
    }

    private NamedTransformer<CyNetwork, CyIdentifiable> toNamedController(TransformerElement element) {
        Transformer[] transformers = element.getChain().toArray(new Transformer[element.getChain().size()]);
        return ModelUtil.createNamedTransformer(element.name, transformers);
    }

    @Override
    public NamedTransformer<CyNetwork, CyIdentifiable> getSelectedNamedTransformer() {
        DynamicComboBoxModel model = this.getElementComboBoxModel();
        return this.toNamedController((TransformerElement)model.getSelectedItem());
    }

    @Override
    public void unregisterView(JComponent elementView) {
    }

    @Override
    public boolean supportsDrop(TransformerPanel parent, List<Integer> sourcePath, JComponent source, List<Integer> targetPath, JComponent target) {
        boolean targetIsFilter;
        if (!super.supportsDrop(parent, sourcePath, source, targetPath, target)) {
            return false;
        }
        boolean sourceIsFilter = sourcePath.size() > 1;
        boolean bl = targetIsFilter = targetPath.size() > 1 || target instanceof CompositeFilterPanel;
        if (sourceIsFilter && targetIsFilter) {
            return true;
        }
        return !sourceIsFilter && !targetIsFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleDrop(TransformerPanel parent, JComponent source, List<Integer> sourcePath, JComponent target, List<Integer> targetPath) {
        CompositeTransformerPanel root = parent.getRootPanel();
        try {
            if (sourcePath.size() == 1 && targetPath.size() == 1) {
                int sourceIndex = sourcePath.get(0);
                List<Transformer<CyNetwork, CyIdentifiable>> model = root.getModel();
                Transformer<CyNetwork, CyIdentifiable> transformer = model.remove(sourceIndex);
                int targetIndex = targetPath.get(targetPath.size() - 1) + 1;
                if (sourceIndex < targetIndex) {
                    --targetIndex;
                }
                model.add(targetIndex, transformer);
            } else {
                super.handleFilterDrop(parent, source, sourcePath, target, targetPath);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            root.updateLayout();
        }
    }

    @Override
    public boolean isDropMove(TransformerPanel view, JComponent source, List<Integer> sourcePath, JComponent target, List<Integer> targetPath) {
        if (sourcePath.size() == 1 && targetPath.size() == 1) {
            return true;
        }
        return target instanceof CompositeSeparator || target instanceof CompositeFilterPanel;
    }
}

