/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.view;

import java.awt.Component;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.cytoscape.filter.internal.filters.composite.CompositeFilterPanel;
import org.cytoscape.filter.internal.view.AbstractPanel;
import org.cytoscape.filter.internal.view.DynamicComboBoxModel;
import org.cytoscape.filter.internal.view.FilterElement;
import org.cytoscape.filter.internal.view.FilterPanelController;
import org.cytoscape.filter.internal.view.TransformerElementViewModel;
import org.cytoscape.filter.internal.work.FilterWorker;
import org.cytoscape.filter.model.CompositeFilter;
import org.cytoscape.filter.model.Transformer;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class FilterPanel
extends AbstractPanel<FilterElement, FilterPanelController> {
    private CompositeFilterPanel<FilterPanel> root;
    private JCheckBox applyAutomaticallyCheckBox;

    public FilterPanel(FilterPanelController controller, FilterWorker worker, CyServiceRegistrar serviceRegistrar) {
        super(controller, serviceRegistrar);
        this.setOpaque(!LookAndFeelUtil.isAquaLAF());
        worker.setView(this);
        this.applyAutomaticallyCheckBox = new JCheckBox("Apply when filter changes");
        this.applyAutomaticallyCheckBox.addActionListener(e -> controller.setInteractive(this.applyAutomaticallyCheckBox.isSelected(), this));
        this.applyAutomaticallyCheckBox.setOpaque(!LookAndFeelUtil.isAquaLAF());
        this.applyAutomaticallyCheckBox.setToolTipText("<html>Apply the filter automatically when the filter definition changes.<br>(Turned off by default for networks that are very large.)</html>");
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.applyAutomaticallyCheckBox});
        JPanel applyPanel = this.createApplyPanel(true);
        Component editPanel = this.createEditPanel();
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.namedElementComboBox, -1, -1, Short.MAX_VALUE).addComponent(this.optionsButton, -2, 64, -2)).addComponent(editPanel, -1, -1, Short.MAX_VALUE).addComponent(this.applyAutomaticallyCheckBox, -1, -1, Short.MAX_VALUE).addComponent(applyPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.namedElementComboBox, -2, -1, -2).addComponent(this.optionsButton, -1, -1, Short.MAX_VALUE)).addComponent(editPanel, -1, -1, Short.MAX_VALUE).addComponent(this.applyAutomaticallyCheckBox, -2, -1, -2).addComponent(applyPanel, -2, -1, -2));
        DynamicComboBoxModel model = controller.getElementComboBoxModel();
        FilterElement element = (FilterElement)model.getSelectedItem();
        this.createView(element.getFilter());
        controller.synchronize(this);
    }

    private void createView(CompositeFilter<CyNetwork, CyIdentifiable> filter) {
        if (filter == null) {
            this.setRootPanel(null);
            return;
        }
        CompositeFilterPanel panel = (CompositeFilterPanel)((FilterPanelController)this.controller).createView(this, (Transformer<CyNetwork, CyIdentifiable>)filter, 0);
        new TransformerElementViewModel<FilterPanel>(panel, this.controller, this);
        this.setRootPanel(panel);
    }

    @Override
    public CompositeFilterPanel<FilterPanel> getRootPanel() {
        return this.root;
    }

    public void setRootPanel(CompositeFilterPanel<FilterPanel> panel) {
        this.root = panel;
        this.scrollPane.setViewportView(this.root);
        if (this.root == null) {
            return;
        }
        this.root.updateLayout();
    }

    public JComboBox getFilterComboBox() {
        return this.namedElementComboBox;
    }

    public JCheckBox getApplyAutomaticallyCheckBox() {
        return this.applyAutomaticallyCheckBox;
    }

    @Override
    public void reset() {
        this.setRootPanel(null);
    }
}

