/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.range;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JRangeSlider
extends JComponent
implements MouseListener,
MouseMotionListener,
KeyListener,
SwingConstants {
    protected static final int HPAD = 2;
    protected static final int VPAD = 4;
    protected static final int THUMB_SIZE = 14;
    protected static final int TRACK_THICKNESS = 4;
    protected BoundedRangeModel model;
    protected int orientation;
    protected int increment = 1;
    protected int minExtent = 0;
    protected ArrayList<ChangeListener> listeners = new ArrayList();
    protected ChangeEvent changeEvent;
    protected ChangeListener lstnr;
    protected final Color trackColor1 = UIManager.getColor("Panel.background").darker();
    protected final Color trackColor2 = UIManager.getColor("Panel.background");
    protected final Color rangeColor1 = UIManager.getColor("TextField.background");
    protected final Color rangeColor2 = UIManager.getColor("TextField.selectionBackground");
    protected final Color thumbColor1 = UIManager.getColor("TextField.background");
    protected final Color thumbColor2 = UIManager.getColor("Button.background");
    protected final Color borderColor = UIManager.getColor("Label.disabledForeground");
    protected final Color disabledBorderColor = UIManager.getColor("Label.disabledForeground");
    protected final Color rangeBorderColor = this.rangeColor2.darker();
    static final int PICK_NONE = 0;
    static final int PICK_THUMB_1 = 1;
    static final int PICK_RANGE = 2;
    static final int PICK_THUMB_2 = 3;
    int pick;
    int pickOffsetLow;
    int pickOffsetHigh;
    int mouse;

    public JRangeSlider(BoundedRangeModel model, int orientation) {
        super.setFocusable(true);
        this.model = model;
        this.orientation = orientation;
        if (orientation == 1) {
            this.setMinimumSize(new Dimension(22, 88));
        } else {
            this.setMinimumSize(new Dimension(88, 22));
        }
        this.setPreferredSize(this.getMinimumSize());
        this.lstnr = this.createListener();
        model.addChangeListener(this.lstnr);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
    }

    protected ChangeListener createListener() {
        return new RangeSliderChangeListener();
    }

    public int getLowValue() {
        return this.model.getValue();
    }

    public void setLowValue(int lowValue) {
        int e = this.model.getValue() - lowValue + this.model.getExtent();
        this.model.setRangeProperties(lowValue, e, this.model.getMinimum(), this.model.getMaximum(), false);
        this.model.setValue(lowValue);
    }

    public int getHighValue() {
        return this.model.getValue() + this.model.getExtent();
    }

    public void setHighValue(int highValue) {
        this.model.setExtent(highValue - this.model.getValue());
    }

    public void setRange(int lowValue, int highValue) {
        this.model.setRangeProperties(lowValue, highValue - lowValue, this.model.getMinimum(), this.model.getMaximum(), false);
    }

    public int getMinimum() {
        return this.model.getMinimum();
    }

    public void setMinimum(int minimum) {
        this.model.setMinimum(minimum);
    }

    public int getMaximum() {
        return this.model.getMaximum();
    }

    public void setMaximum(int maximum) {
        this.model.setMaximum(maximum);
    }

    public void setMinExtent(int minExtent) {
        this.minExtent = minExtent;
    }

    public BoundedRangeModel getModel() {
        return this.model;
    }

    public void setModel(BoundedRangeModel brm) {
        this.model.removeChangeListener(this.lstnr);
        this.model = brm;
        this.model.addChangeListener(this.lstnr);
        this.repaint();
    }

    public void addChangeListener(ChangeListener cl) {
        if (!this.listeners.contains(cl)) {
            this.listeners.add(cl);
        }
    }

    public void removeChangeListener(ChangeListener cl) {
        this.listeners.remove(cl);
    }

    protected void fireChangeEvent() {
        this.repaint();
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        Iterator<ChangeListener> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            iter.next().stateChanged(this.changeEvent);
        }
    }

    protected void customPaint(Graphics2D g, int width, int height) {
    }

    @Override
    public void paintComponent(Graphics g) {
        int h;
        int w;
        boolean vertical = this.orientation == 1;
        Rectangle bounds = this.getBounds();
        int width = (int)Math.round(bounds.getWidth() - (double)(2 * (vertical ? 4 : 2)));
        int height = (int)Math.round(bounds.getHeight() - (double)(2 * (vertical ? 2 : 4)));
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int x = this.trackX();
        int y = this.trackY();
        if (vertical) {
            w = 4;
            h = height - 14;
        } else {
            w = width - 14;
            h = 4;
        }
        this.paintTrack(g2, this.trackColor1, this.trackColor2, this.isEnabled() ? this.borderColor : this.disabledBorderColor, x, y, w, h);
        this.customPaint(g2, width, height);
        int min = this.toScreen(this.getLowValue());
        int max = this.toScreen(this.getHighValue());
        if (vertical) {
            y = min;
            h = max - y;
        } else {
            x = min;
            w = max - x;
        }
        this.paintTrack(g2, this.rangeColor1, this.isEnabled() ? this.rangeColor2 : this.trackColor2, this.isEnabled() ? this.rangeBorderColor : this.disabledBorderColor, x, y, w, h);
        h = 14;
        w = 14;
        if (vertical) {
            x = (int)Math.round((bounds.getWidth() - 14.0) / 2.0);
            y -= 14;
        } else {
            x -= 14;
            y = (int)Math.round((bounds.getHeight() - 14.0) / 2.0);
        }
        this.paintThumb(g2, this.isEnabled() ? this.thumbColor1 : this.thumbColor2, this.thumbColor2, x, y, w, h);
        if (vertical) {
            y = max;
        } else {
            x = max;
        }
        this.paintThumb(g2, this.isEnabled() ? this.thumbColor1 : this.thumbColor2, this.thumbColor2, x, y, w, h);
    }

    private int trackX() {
        return this.orientation == 1 ? (int)Math.round((this.getBounds().getWidth() - 4.0) / 2.0) : (int)Math.round(9.0);
    }

    private int trackY() {
        return this.orientation == 1 ? (int)Math.round(9.0) : (int)Math.round((this.getBounds().getHeight() - 4.0) / 2.0);
    }

    private void paintTrack(Graphics g, Color color1, Color color2, Color borderColor, int x, int y, int w, int h) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Point p1 = this.orientation == 1 ? new Point(x, y) : new Point(x, y);
        Point p2 = this.orientation == 1 ? new Point(x + w, y) : new Point(x, y + h);
        GradientPaint p = new GradientPaint(p1, color1, p2, color2);
        int arc = 4;
        g2.setPaint(p);
        g2.fillRoundRect(x, y, w, h, 4, 4);
        g2.setColor(borderColor);
        g2.setStroke(new BasicStroke(1.0f));
        g2.drawRoundRect(x, y, w, h, 4, 4);
        g2.dispose();
    }

    private void paintThumb(Graphics g, Color color1, Color color2, int x, int y, int w, int h) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Point p1 = new Point(x, y);
        Point p2 = new Point(x, y + h);
        GradientPaint p = new GradientPaint(p1, color1, p2, color2);
        g2.setPaint(p);
        g2.fillOval(x, y, w, h);
        g2.setColor(this.isEnabled() ? this.borderColor : this.disabledBorderColor);
        g2.setStroke(new BasicStroke(1.0f));
        g2.drawOval(x, y, w, h);
        g2.dispose();
    }

    protected int toLocal(int xOrY) {
        Dimension d = this.getSize();
        int min = this.getMinimum();
        int max = this.getMaximum();
        double length = this.orientation == 1 ? (double)d.height : (double)d.width;
        double scale = (length - 4.0 - 14.0) / (double)(max - min);
        return (int)((double)(xOrY - 14) / scale + (double)min + 0.5);
    }

    protected int toScreen(int xOrY) {
        Dimension d = this.getSize();
        int min = this.getMinimum();
        int max = this.getMaximum();
        double length = this.orientation == 1 ? (double)d.height : (double)d.width;
        double scale = (length - 4.0 - 28.0) / (double)(max - min);
        return (int)(16.0 + (double)(xOrY - min) * scale);
    }

    private int pickHandle(int xOrY) {
        int min = this.toScreen(this.getLowValue());
        int max = this.toScreen(this.getHighValue());
        int pick = 0;
        if (xOrY >= min - 14 && xOrY <= min) {
            pick = 1;
        } else if (xOrY > min && xOrY < max) {
            pick = 2;
        } else if (xOrY >= max && xOrY <= max + 14) {
            pick = 3;
        }
        return pick;
    }

    private void offset(int dxOrDy) {
        this.model.setValue(this.model.getValue() + dxOrDy);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.orientation == 1) {
            this.pick = this.pickHandle(e.getY());
            this.pickOffsetLow = e.getY() - this.toScreen(this.getLowValue());
            this.pickOffsetHigh = e.getY() - this.toScreen(this.getHighValue());
            this.mouse = e.getY();
        } else {
            this.pick = this.pickHandle(e.getX());
            this.pickOffsetLow = e.getX() - this.toScreen(this.getLowValue());
            this.pickOffsetHigh = e.getX() - this.toScreen(this.getHighValue());
            this.mouse = e.getX();
        }
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.requestFocus();
        int value = this.orientation == 1 ? e.getY() : e.getX();
        int minimum = this.getMinimum();
        int maximum = this.getMaximum();
        int lowValue = this.getLowValue();
        int highValue = this.getHighValue();
        switch (this.pick) {
            case 1: {
                int low = this.toLocal(value - this.pickOffsetLow);
                if (low < minimum) {
                    low = minimum;
                }
                if (low > maximum) {
                    low = maximum;
                }
                if (low > highValue - this.minExtent) {
                    low = highValue - this.minExtent;
                }
                this.setLowValue(low);
                break;
            }
            case 3: {
                int high = this.toLocal(value - this.pickOffsetHigh);
                if (high < minimum) {
                    high = minimum;
                }
                if (high > maximum) {
                    high = maximum;
                }
                if (high < lowValue + this.minExtent) {
                    high = lowValue + this.minExtent;
                }
                this.setHighValue(high);
                break;
            }
            case 2: {
                int dxOrDy = this.toLocal(value - this.pickOffsetLow) - lowValue;
                if (dxOrDy < 0 && lowValue + dxOrDy < minimum) {
                    dxOrDy = minimum - lowValue;
                }
                if (dxOrDy > 0 && highValue + dxOrDy > maximum) {
                    dxOrDy = maximum - highValue;
                }
                if (dxOrDy == 0) break;
                this.offset(dxOrDy);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.isEnabled()) {
            this.pick = 0;
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.orientation == 1) {
            switch (this.pickHandle(e.getY())) {
                case 1: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 3: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 2: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 0: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        } else {
            switch (this.pickHandle(e.getX())) {
                case 1: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 3: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 2: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 0: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void grow(int increment) {
        this.model.setRangeProperties(this.model.getValue() - increment, this.model.getExtent() + 2 * increment, this.model.getMinimum(), this.model.getMaximum(), false);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        int kc = e.getKeyCode();
        boolean v = this.orientation == 1;
        boolean d = kc == 40;
        boolean u = kc == 38;
        boolean l = kc == 37;
        boolean r = kc == 39;
        int minimum = this.getMinimum();
        int maximum = this.getMaximum();
        int lowValue = this.getLowValue();
        int highValue = this.getHighValue();
        if (v && r || !v && u) {
            if (lowValue - this.increment >= minimum && highValue + this.increment <= maximum) {
                this.grow(this.increment);
            }
        } else if (v && l || !v && d) {
            if (highValue - lowValue >= 2 * this.increment) {
                this.grow(-1 * this.increment);
            }
        } else if (v && d || !v && l) {
            if (lowValue - this.increment >= minimum) {
                this.offset(-this.increment);
            }
        } else if ((v && u || !v && r) && highValue + this.increment <= maximum) {
            this.offset(this.increment);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    protected class RangeSliderChangeListener
    implements ChangeListener {
        protected RangeSliderChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JRangeSlider.this.fireChangeEvent();
        }
    }
}

