/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.filters.composite;

import java.awt.dnd.DropTarget;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.cytoscape.filter.internal.filters.composite.CompositeFilterPanel;
import org.cytoscape.filter.internal.filters.composite.CompositeSeparator;
import org.cytoscape.filter.internal.view.CompositePanelComponent;
import org.cytoscape.filter.internal.view.DragHandler;
import org.cytoscape.filter.internal.view.TransformerElementViewModel;
import org.cytoscape.filter.internal.view.TransformerPanel;
import org.cytoscape.filter.internal.view.TransformerPanelController;
import org.cytoscape.filter.internal.view.ViewUtil;
import org.cytoscape.filter.model.Transformer;
import org.cytoscape.filter.model.ValidatableTransformer;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class CompositeTransformerPanel
extends JPanel
implements CompositePanelComponent {
    private Map<Transformer<CyNetwork, CyIdentifiable>, TransformerElementViewModel<TransformerPanel>> viewModels;
    private GroupLayout layout;
    private final JButton addButton;
    private TransformerPanel parent;
    private TransformerPanelController transformerPanelController;
    private List<Transformer<CyNetwork, CyIdentifiable>> model;
    private JComponent separator;
    private final CyServiceRegistrar serviceRegistrar;

    public CompositeTransformerPanel(TransformerPanel parent, TransformerPanelController transformerPanelController, List<Transformer<CyNetwork, CyIdentifiable>> model, CyServiceRegistrar serviceRegistrar) {
        this(parent, transformerPanelController, new Controller(), model, serviceRegistrar);
    }

    CompositeTransformerPanel(TransformerPanel parent, TransformerPanelController transformerPanelController, Controller controller, List<Transformer<CyNetwork, CyIdentifiable>> model, CyServiceRegistrar serviceRegistrar) {
        this.parent = parent;
        this.transformerPanelController = transformerPanelController;
        this.model = model;
        this.serviceRegistrar = serviceRegistrar;
        this.separator = new CompositeSeparator();
        new DropTarget(this.separator, new DragHandler<TransformerPanel>(this.separator, transformerPanelController, parent, null));
        ViewUtil.configureFilterView(this);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.viewModels = new WeakHashMap<Transformer<CyNetwork, CyIdentifiable>, TransformerElementViewModel<TransformerPanel>>();
        this.layout = new GroupLayout(this);
        this.setLayout(this.layout);
        this.addButton = this.createAddChainEntryButton();
        for (Transformer<CyNetwork, CyIdentifiable> transformer : model) {
            TransformerElementViewModel<TransformerPanel> viewModel = this.createViewModel(transformer);
            this.viewModels.put(transformer, viewModel);
        }
    }

    private TransformerElementViewModel<TransformerPanel> createViewModel(Transformer<CyNetwork, CyIdentifiable> transformer) {
        JComponent component = this.transformerPanelController.createView(this.parent, transformer, 0);
        TransformerElementViewModel<TransformerPanel> viewModel = new TransformerElementViewModel<TransformerPanel>(component, this.transformerPanelController, this.parent);
        if (transformer instanceof ValidatableTransformer) {
            this.transformerPanelController.getValidationManager().register((ValidatableTransformer<CyNetwork, CyIdentifiable>)((ValidatableTransformer)transformer), viewModel);
        }
        return viewModel;
    }

    JButton createAddChainEntryButton() {
        JButton button = new JButton("\uf067");
        button.setFont(((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(11.0f));
        button.setToolTipText("Add new chain entry...");
        if (LookAndFeelUtil.isAquaLAF()) {
            button.putClientProperty("JButton.buttonType", "gradient");
        }
        button.addActionListener(evt -> {
            JPopupMenu menu = this.transformerPanelController.createAddChainEntryMenu(this, this.parent);
            menu.show(button, 0, button.getHeight());
        });
        return button;
    }

    @Override
    public void updateLayout() {
        this.removeAll();
        GroupLayout.ParallelGroup checkBoxGroup = this.layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.ParallelGroup viewGroup = this.layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.ParallelGroup columns = this.layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addGroup(this.layout.createSequentialGroup().addGap(4).addGroup(checkBoxGroup).addGap(4).addGroup(viewGroup));
        GroupLayout.SequentialGroup rows = this.layout.createSequentialGroup();
        int separatorHeight = 5;
        viewGroup.addComponent(this.separator);
        ((GroupLayout.Group)rows).addComponent(this.separator, separatorHeight, separatorHeight, separatorHeight);
        for (Transformer<CyNetwork, CyIdentifiable> transformer : this.model) {
            TransformerElementViewModel<TransformerPanel> viewModel = this.viewModels.get(transformer);
            if (viewModel.view instanceof CompositeFilterPanel) {
                CompositeFilterPanel panel = (CompositeFilterPanel)viewModel.view;
                panel.updateLayout();
            }
            checkBoxGroup.addGroup(this.layout.createParallelGroup().addGroup(this.layout.createSequentialGroup().addComponent(viewModel.deleteButton, -1, -1, -1).addGap(4).addComponent(viewModel.handle, -1, -1, -1)).addGap(4).addComponent(viewModel.warnIcon, GroupLayout.Alignment.CENTER));
            viewGroup.addComponent(viewModel.view, 0, -2, Short.MAX_VALUE).addComponent(viewModel.separator);
            ((GroupLayout.Group)rows).addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(this.layout.createSequentialGroup().addGap(4).addGroup(this.layout.createSequentialGroup().addGroup(this.layout.createParallelGroup().addComponent(viewModel.deleteButton, -1, -1, -1).addComponent(viewModel.handle, -2, -2, -2)).addGap(4).addComponent(viewModel.warnIcon))).addComponent(viewModel.view, -2, -1, -2));
            ((GroupLayout.Group)rows).addComponent(viewModel.separator, separatorHeight, separatorHeight, separatorHeight);
        }
        ((GroupLayout.Group)columns).addComponent(this.addButton);
        ((GroupLayout.Group)rows).addGap(4).addComponent(this.addButton);
        this.layout.setHorizontalGroup(columns);
        this.layout.setVerticalGroup(rows);
    }

    public void addTransformer(Transformer<CyNetwork, CyIdentifiable> transformer) {
        TransformerElementViewModel<TransformerPanel> viewModel = this.createViewModel(transformer);
        this.addViewModel(transformer, viewModel);
    }

    public void addViewModel(Transformer<CyNetwork, CyIdentifiable> transformer, TransformerElementViewModel<TransformerPanel> viewModel) {
        this.model.add(transformer);
        this.viewModels.put(transformer, viewModel);
    }

    @Override
    public void removeTransformer(int index, boolean unregister) {
        Transformer<CyNetwork, CyIdentifiable> transformer = this.model.remove(index);
        TransformerElementViewModel<TransformerPanel> model = this.viewModels.remove(transformer);
        if (model != null && model.view != null) {
            this.transformerPanelController.unregisterView(model.view);
        }
        if (transformer instanceof ValidatableTransformer) {
            this.transformerPanelController.getValidationManager().unregister((ValidatableTransformer<CyNetwork, CyIdentifiable>)((ValidatableTransformer)transformer));
        }
    }

    public List<Transformer<CyNetwork, CyIdentifiable>> getModel() {
        return this.model;
    }

    public TransformerElementViewModel<TransformerPanel> getViewModel(Transformer<CyNetwork, CyIdentifiable> transformer) {
        return this.viewModels.get(transformer);
    }

    @Override
    public JComponent getSeparator() {
        return this.separator;
    }

    @Override
    public int getTransformerCount() {
        return this.model.size();
    }

    @Override
    public Transformer<CyNetwork, CyIdentifiable> getTransformerAt(int index) {
        return this.model.get(index);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    static class Controller {
        List<Transformer<CyNetwork, CyIdentifiable>> model = new ArrayList<Transformer<CyNetwork, CyIdentifiable>>();

        Controller() {
        }
    }
}

