/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.filters.composite;

import java.util.ArrayList;
import java.util.List;
import org.cytoscape.filter.internal.ApplyCheck;
import org.cytoscape.filter.internal.MemoizableTransformer;
import org.cytoscape.filter.model.AbstractTransformer;
import org.cytoscape.filter.model.CompositeFilter;
import org.cytoscape.filter.model.Filter;
import org.cytoscape.work.Tunable;

public class CompositeFilterImpl<C, E>
extends AbstractTransformer<C, E>
implements CompositeFilter<C, E>,
MemoizableTransformer,
ApplyCheck<C, E> {
    static final String ID = "org.cytoscape.CompositeFilter";
    public static final CompositeFilter.Type DEFAULT_TYPE = CompositeFilter.Type.ALL;
    private CompositeFilter.Type type = DEFAULT_TYPE;
    final List<Filter<C, E>> filters = new ArrayList<Filter<C, E>>();
    private Class<C> contextType;
    private Class<E> elementType;

    public CompositeFilterImpl(Class<C> contextType, Class<E> elementType) {
        this.contextType = contextType;
        this.elementType = elementType;
    }

    public String getName() {
        return "Group";
    }

    public String getId() {
        return ID;
    }

    public void append(Filter<C, E> filter) {
        this.checkTypes(filter);
        this.filters.add(filter);
        this.notifyListeners();
    }

    private void checkTypes(Filter<C, E> filter) {
        Class otherContextType = filter.getContextType();
        if (!otherContextType.equals(this.contextType)) {
            throw new IllegalArgumentException("Incompatible context type: " + otherContextType);
        }
        Class otherElementType = filter.getElementType();
        if (!otherElementType.equals(this.elementType)) {
            throw new IllegalArgumentException("Incompatible element type: " + otherElementType);
        }
    }

    public void insert(int index, Filter<C, E> filter) {
        this.checkTypes(filter);
        this.filters.add(index, filter);
        this.notifyListeners();
    }

    public Filter<C, E> get(int index) {
        return this.filters.get(index);
    }

    public Filter<C, E> remove(int index) {
        try {
            Filter<C, E> filter = this.filters.remove(index);
            return filter;
        }
        finally {
            this.notifyListeners();
        }
    }

    public int getLength() {
        return this.filters.size();
    }

    @Tunable
    public CompositeFilter.Type getType() {
        return this.type;
    }

    public void setType(CompositeFilter.Type type) {
        this.type = type;
        this.notifyListeners();
    }

    public int indexOf(Filter<C, E> filter) {
        return this.filters.indexOf(filter);
    }

    @Override
    public void startCaching() {
        for (Filter<C, E> filter : this.filters) {
            if (!(filter instanceof MemoizableTransformer)) continue;
            ((MemoizableTransformer)filter).startCaching();
        }
    }

    @Override
    public void clearCache() {
        for (Filter<C, E> filter : this.filters) {
            if (!(filter instanceof MemoizableTransformer)) continue;
            ((MemoizableTransformer)filter).clearCache();
        }
    }

    public boolean accepts(C context, E element) {
        if (this.filters.isEmpty()) {
            return true;
        }
        for (Filter<C, E> filter : this.filters) {
            boolean result = filter.accepts(context, element);
            if (result == (this.type == CompositeFilter.Type.ALL)) continue;
            return result;
        }
        return this.type == CompositeFilter.Type.ALL;
    }

    public boolean isAlwaysFalse() {
        if (this.filters.isEmpty()) {
            return false;
        }
        for (Filter<C, E> filter : this.filters) {
            boolean result = filter.isAlwaysFalse();
            if (result != (this.type == CompositeFilter.Type.ALL)) continue;
            return result;
        }
        return this.type != CompositeFilter.Type.ALL;
    }

    @Override
    public boolean appliesTo(C context, E element) {
        if (this.filters.isEmpty()) {
            return false;
        }
        for (Filter<C, E> filter : this.filters) {
            boolean applies = filter instanceof ApplyCheck ? ((ApplyCheck)filter).appliesTo(context, element) : true;
            if (!applies) continue;
            return true;
        }
        return false;
    }

    public Class<C> getContextType() {
        return this.contextType;
    }

    public Class<E> getElementType() {
        return this.elementType;
    }
}

