/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.property.internal.bookmark;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.cytoscape.io.DataCategory;
import org.cytoscape.io.datasource.DefaultDataSource;
import org.cytoscape.property.bookmark.Attribute;
import org.cytoscape.property.bookmark.Bookmarks;
import org.cytoscape.property.bookmark.BookmarksUtil;
import org.cytoscape.property.bookmark.Category;
import org.cytoscape.property.bookmark.DataSource;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookmarksUtilImpl
implements BookmarksUtil {
    private Map<DataSource, org.cytoscape.io.datasource.DataSource> dataSourceMap;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private CyServiceRegistrar register;

    public BookmarksUtilImpl(CyServiceRegistrar register) {
        this.register = register;
        this.dataSourceMap = new HashMap<DataSource, org.cytoscape.io.datasource.DataSource>();
    }

    public List<DataSource> getDataSourceList(String categoryName, List<Category> categoryList) {
        Category targetCat = this.getCategory(categoryName, categoryList);
        if (targetCat != null) {
            return this.extractDataSources(targetCat);
        }
        return null;
    }

    public Category getCategory(String categoryName, List<Category> categoryList) {
        Category result = null;
        for (Category cat : categoryList) {
            if (cat.getName().equals(categoryName)) {
                result = cat;
                break;
            }
            List<Category> subCategories = this.extractCategory(cat);
            if (subCategories.size() != 0 && result == null) {
                result = this.getCategory(categoryName, subCategories);
            }
            if (result == null) continue;
            break;
        }
        return result;
    }

    public String getAttribute(DataSource source, String attrName) {
        List attrs = source.getAttribute();
        for (Attribute attr : attrs) {
            if (!attrName.equals(attr.getName())) continue;
            return attr.getContent();
        }
        return null;
    }

    private List<DataSource> extractDataSources(Category cat) {
        List entries = cat.getCategoryOrDataSource();
        ArrayList<DataSource> datasourceList = new ArrayList<DataSource>();
        for (Object obj : entries) {
            if (obj.getClass() != DataSource.class) continue;
            datasourceList.add((DataSource)obj);
        }
        return datasourceList;
    }

    private List<Category> extractCategory(Category cat) {
        List entries = cat.getCategoryOrDataSource();
        ArrayList<Category> categoryList = new ArrayList<Category>();
        for (Object obj : entries) {
            if (obj.getClass() != Category.class) continue;
            categoryList.add((Category)obj);
        }
        return categoryList;
    }

    public void saveBookmark(Bookmarks pBookmarks, String pCategoryName, DataSource pDataSource) {
        this.saveBookmark(pBookmarks, pCategoryName, pDataSource, "Example");
    }

    public void saveBookmark(Bookmarks pBookmarks, String pCategoryName, DataSource pDataSource, String pProvider) {
        org.cytoscape.io.datasource.DataSource data;
        List theObjList;
        Category theCategory;
        List theCategoryList;
        if (pBookmarks == null) {
            pBookmarks = new Bookmarks();
        }
        if ((theCategoryList = pBookmarks.getCategory()).size() == 0) {
            theCategory = new Category();
            theCategory.setName(pCategoryName);
            theCategoryList.add(theCategory);
        }
        if ((theCategory = this.getCategory(pCategoryName, theCategoryList)) == null) {
            Category newCategory = new Category();
            newCategory.setName(pCategoryName);
            theCategoryList.add(newCategory);
            theCategory = newCategory;
        }
        if (!(theObjList = theCategory.getCategoryOrDataSource()).contains(pDataSource)) {
            theObjList.add(pDataSource);
        }
        if ((data = this.convertToDataSource(pBookmarks, pCategoryName, pDataSource, pProvider)) != null && !this.dataSourceMap.containsKey(pDataSource)) {
            this.register.registerService((Object)data, org.cytoscape.io.datasource.DataSource.class, new Properties());
            this.dataSourceMap.put(pDataSource, data);
        }
    }

    public org.cytoscape.io.datasource.DataSource convertToDataSource(Bookmarks pBookmarks, String pCategoryName, DataSource pDataSource) {
        return this.convertToDataSource(pBookmarks, pCategoryName, pDataSource, "Example");
    }

    public org.cytoscape.io.datasource.DataSource convertToDataSource(Bookmarks pBookmarks, String pCategoryName, DataSource pDataSource, String pProvider) {
        DataCategory dataType;
        String location = pDataSource.getHref();
        String name = pDataSource.getName();
        String description = "From Bookmarks";
        URL url = null;
        if (pCategoryName.contentEquals("network")) {
            dataType = DataCategory.NETWORK;
        } else if (pCategoryName.contentEquals("table")) {
            dataType = DataCategory.TABLE;
        } else {
            return null;
        }
        try {
            url = new URL(location);
        }
        catch (MalformedURLException e) {
            logger.warn("Bookmark file coniatin invalid URL: " + location);
            return null;
        }
        return new DefaultDataSource(name, pProvider, "From Bookmarks", dataType, url);
    }

    public boolean deleteBookmark(Bookmarks pBookmarks, String pCategoryName, DataSource pDataSource) {
        if (!this.containsBookmarks(pBookmarks, pCategoryName, pDataSource)) {
            return false;
        }
        List theCategoryList = pBookmarks.getCategory();
        Category theCategory = this.getCategory(pCategoryName, theCategoryList);
        List theObjList = theCategory.getCategoryOrDataSource();
        for (int i = 0; i < theObjList.size(); ++i) {
            DataSource theDataSource;
            Object obj = theObjList.get(i);
            if (!(obj instanceof DataSource) || !(theDataSource = (DataSource)obj).getName().equalsIgnoreCase(pDataSource.getName())) continue;
            if (this.dataSourceMap.containsKey(pDataSource)) {
                this.register.unregisterService((Object)this.dataSourceMap.get(pDataSource), org.cytoscape.io.datasource.DataSource.class);
                this.dataSourceMap.remove(pDataSource);
            }
            theObjList.remove(i);
        }
        return true;
    }

    public boolean containsBookmarks(Bookmarks pBookmarks, String pCategoryName, DataSource pDataSource) {
        if (pBookmarks == null) {
            return false;
        }
        List<DataSource> theDataSources = this.getDataSourceList(pCategoryName, pBookmarks.getCategory());
        if (theDataSources == null || theDataSources.size() == 0) {
            return false;
        }
        for (DataSource theDataSource : theDataSources) {
            if (!theDataSource.getName().equalsIgnoreCase(pDataSource.getName())) continue;
            return true;
        }
        return false;
    }

    public String getProvider(DataSource pDataSource) {
        if (pDataSource == null || this.dataSourceMap.get(pDataSource) == null) {
            return null;
        }
        return this.dataSourceMap.get(pDataSource).getProvider();
    }
}

