/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.launcher.internal;

import java.awt.BorderLayout;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.karaf.main.Main;
import org.cytoscape.launcher.internal.MacHelper;
import org.cytoscape.launcher.internal.SplashPanel;

public class Launcher {
    public static String[] startupArguments;
    private static long startTime;
    private static SplashPanel splashPanel;

    public static void main(String[] args) throws Exception {
        startTime = System.currentTimeMillis();
        startupArguments = args;
        Launcher.showSplashPanel();
        if (Launcher.isMac()) {
            MacHelper.handleStartupArguments();
        }
        Launcher.setDefaultSystemProperties();
        Launcher.createConfigurationDirectory();
        if (Launcher.isLocked()) {
            String dataPath = String.format("%s.%d", System.getProperty("karaf.data"), System.currentTimeMillis());
            System.setProperty("karaf.data", dataPath);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                File root = new File(dataPath);
                Launcher.deleteDirectory(root);
            }));
        }
        Main.main((String[])args);
    }

    private static void showSplashPanel() throws IOException {
        File karafBase = new File(System.getProperty("karaf.base"));
        System.out.println("karaf.base: " + karafBase);
        System.out.println("JAVA_HOME: " + System.getenv("JAVA_HOME"));
        File svgFile = new File(karafBase, "CytoscapeSplashScreen.svg");
        String svg = svgFile.exists() ? Files.readString(svgFile.toPath()) : null;
        splashPanel = new SplashPanel(svg);
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add(splashPanel);
        frame.setUndecorated(true);
        frame.setResizable(false);
        frame.pack();
        int width = frame.getPreferredSize().width;
        int height = frame.getPreferredSize().height;
        Rectangle bounds = frame.getGraphicsConfiguration().getBounds();
        frame.setLocation((bounds.width - width) / 2, (bounds.height - height) / 2);
        SwingUtilities.invokeLater(() -> frame.setVisible(true));
    }

    private static void deleteDirectory(File root) {
        LinkedList<File> pathStack = new LinkedList<File>();
        pathStack.push(root);
        HashSet<File> seen = new HashSet<File>();
        while (!pathStack.isEmpty()) {
            File directory = (File)pathStack.pop();
            File[] files = directory.listFiles();
            if (files.length == 0) {
                seen.add(directory);
                directory.delete();
                continue;
            }
            if (seen.contains(directory)) {
                System.err.printf("Couldn't delete bundle cache: %s\n", directory.getAbsolutePath());
                continue;
            }
            seen.add(directory);
            pathStack.push(directory);
            for (File file : files) {
                if (file.isDirectory()) {
                    pathStack.push(file);
                    continue;
                }
                if (!file.isFile()) continue;
                file.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isLocked() throws Exception {
        String lockPath = Launcher.join(File.separator, System.getProperty("karaf.data"), "lock");
        try (RandomAccessFile lockFile = new RandomAccessFile(new File(lockPath), "rw");){
            FileLock lock = lockFile.getChannel().tryLock();
            if (lock != null) {
                lock.release();
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    private static void setDefaultSystemProperties() {
        String userHome = System.getProperty("user.home");
        if (System.getProperty("karaf.data") == null) {
            System.setProperty("karaf.data", Launcher.join(File.separator, userHome, "CytoscapeConfiguration", "3", "karaf_data"));
        }
    }

    private static String join(String separator, String ... parts) {
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (String part : parts) {
            if (!isFirst) {
                builder.append(separator);
            } else {
                isFirst = false;
            }
            builder.append(part);
        }
        return builder.toString();
    }

    private static void createConfigurationDirectory() {
        String userHome = System.getProperty("user.home");
        File karafData = new File(Launcher.join(File.separator, userHome, "CytoscapeConfiguration", "3"));
        karafData.mkdirs();
        File karafTmp = new File(karafData, "tmp");
        karafTmp.mkdirs();
    }

    public static String[] getStartupArguments() {
        String[] result = new String[startupArguments.length];
        System.arraycopy(startupArguments, 0, result, 0, startupArguments.length);
        return result;
    }

    public static long getStartTime() {
        return startTime;
    }

    private static boolean isMac() {
        return System.getProperty("os.name").startsWith("Mac OS X");
    }

    public static SplashPanel getSplashPanel() {
        return splashPanel;
    }
}

