/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.internal;

import java.awt.Color;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.NetworkViewRenderer;
import org.cytoscape.application.events.SetCurrentNetworkViewEvent;
import org.cytoscape.application.events.SetCurrentNetworkViewListener;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.events.NetworkViewAboutToBeDestroyedEvent;
import org.cytoscape.view.model.events.NetworkViewAboutToBeDestroyedListener;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.view.vizmap.events.SetCurrentVisualStyleEvent;
import org.cytoscape.view.vizmap.events.VisualStyleAboutToBeRemovedEvent;
import org.cytoscape.view.vizmap.events.VisualStyleAddedEvent;
import org.cytoscape.view.vizmap.events.VisualStyleSetEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkVisualMappingManagerImpl
implements VisualMappingManager,
SetCurrentNetworkViewListener,
NetworkViewAboutToBeDestroyedListener {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    public static final String DEFAULT_STYLE_NAME = "default";
    private static final Color NETWORK_COLOR = Color.WHITE;
    private static final Color NODE_COLOR = new Color(79, 148, 205);
    private static final Color NODE_LABEL_COLOR = Color.BLACK;
    private static final Color EDGE_COLOR = new Color(50, 50, 50);
    private static final Double EDGE_WIDTH = 2.0;
    private static final Double NODE_WIDTH = 35.0;
    private static final Double NODE_HEIGHT = 35.0;
    private static final Color EDGE_LABEL_COLOR = Color.BLACK;
    private VisualStyle defaultStyle;
    private volatile VisualStyle currentStyle;
    private final Map<CyNetworkView, VisualStyle> network2VisualStyleMap;
    private final Set<VisualStyle> visualStyles;
    private final CyServiceRegistrar serviceRegistrar;
    private final Object lock = new Object();

    public NetworkVisualMappingManagerImpl(VisualStyleFactory factory, CyServiceRegistrar serviceRegistrar) {
        if (serviceRegistrar == null) {
            throw new NullPointerException("'serviceRegistrar' cannot be null");
        }
        this.serviceRegistrar = serviceRegistrar;
        this.visualStyles = new HashSet<VisualStyle>();
        this.network2VisualStyleMap = new WeakHashMap<CyNetworkView, VisualStyle>();
        this.defaultStyle = this.buildGlobalDefaultStyle(factory);
        this.visualStyles.add(this.defaultStyle);
        this.currentStyle = this.defaultStyle;
    }

    private VisualStyle buildGlobalDefaultStyle(VisualStyleFactory factory) {
        VisualStyle defStyle = factory.createVisualStyle(DEFAULT_STYLE_NAME);
        defStyle.setDefaultValue(BasicVisualLexicon.NETWORK_BACKGROUND_PAINT, (Object)NETWORK_COLOR);
        defStyle.setDefaultValue(BasicVisualLexicon.NODE_FILL_COLOR, (Object)NODE_COLOR);
        defStyle.setDefaultValue(BasicVisualLexicon.NODE_LABEL_COLOR, (Object)NODE_LABEL_COLOR);
        defStyle.setDefaultValue(BasicVisualLexicon.NODE_WIDTH, (Object)NODE_WIDTH);
        defStyle.setDefaultValue(BasicVisualLexicon.NODE_HEIGHT, (Object)NODE_HEIGHT);
        defStyle.setDefaultValue(BasicVisualLexicon.EDGE_WIDTH, (Object)EDGE_WIDTH);
        defStyle.setDefaultValue(BasicVisualLexicon.EDGE_PAINT, (Object)EDGE_COLOR);
        defStyle.setDefaultValue(BasicVisualLexicon.EDGE_LABEL_COLOR, (Object)EDGE_LABEL_COLOR);
        return defStyle;
    }

    public void handleEvent(NetworkViewAboutToBeDestroyedEvent e) {
        CyNetworkView netView = e.getNetworkView();
        this.network2VisualStyleMap.remove(netView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VisualStyle getVisualStyle(CyNetworkView nv) {
        if (nv == null) {
            logger.warn("Attempting to get the visual style for a null network view; returning the default visual style.");
            return this.getDefaultVisualStyle();
        }
        Object object = this.lock;
        synchronized (object) {
            VisualStyle style = this.network2VisualStyleMap.get(nv);
            if (style == null) {
                style = this.getDefaultVisualStyle();
                this.network2VisualStyleMap.put(nv, style);
            }
            return style;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisualStyle(VisualStyle vs, CyNetworkView nv) {
        if (nv == null) {
            throw new NullPointerException("Network view is null.");
        }
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            if (vs == null) {
                changed = this.network2VisualStyleMap.remove(nv) != null;
            } else {
                VisualStyle previousStyle = this.network2VisualStyleMap.put(nv, vs);
                boolean bl = changed = !vs.equals(previousStyle);
            }
            if (!this.visualStyles.contains(vs)) {
                this.visualStyles.add(vs);
            }
        }
        if (changed) {
            CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
            eventHelper.fireEvent((CyEvent)new VisualStyleSetEvent((VisualMappingManager)this, vs, nv));
            CyApplicationManager appManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
            if (appManager != null && nv.equals(appManager.getCurrentNetworkView())) {
                this.setCurrentVisualStyle(vs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVisualStyle(VisualStyle vs) {
        if (vs == null) {
            throw new NullPointerException("Visual Style is null.");
        }
        if (vs == this.defaultStyle) {
            throw new IllegalArgumentException("Cannot remove default visual style.");
        }
        logger.debug("Visual Style about to be removed from VMM: " + vs.getTitle());
        CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
        eventHelper.fireEvent((CyEvent)new VisualStyleAboutToBeRemovedEvent((VisualMappingManager)this, vs));
        Object object = this.lock;
        synchronized (object) {
            this.visualStyles.remove(vs);
        }
        if (this.currentStyle == vs) {
            this.setCurrentVisualStyle(this.getDefaultVisualStyle());
        }
        HashSet<CyNetworkView> viewsToUpdate = new HashSet<CyNetworkView>();
        Iterator iterator = this.lock;
        synchronized (iterator) {
            if (this.network2VisualStyleMap.values().contains(vs)) {
                for (CyNetworkView view : this.network2VisualStyleMap.keySet()) {
                    if (!this.network2VisualStyleMap.get(view).equals(vs)) continue;
                    viewsToUpdate.add(view);
                }
            }
        }
        for (CyNetworkView view : viewsToUpdate) {
            this.setVisualStyle(this.defaultStyle, view);
        }
        logger.debug("Total Number of VS in VMM after remove = " + this.visualStyles.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVisualStyle(VisualStyle vs) {
        Object newTitle;
        if (vs == null) {
            logger.warn("Tried to add null to VMM.");
            return;
        }
        if (this.hasDuplicatedTitle(vs)) {
            newTitle = this.getSuggestedTitle(vs.getTitle());
            vs.setTitle((String)newTitle);
        }
        newTitle = this.lock;
        synchronized (newTitle) {
            this.visualStyles.add(vs);
        }
        logger.debug("New visual Style registered to VMM: " + vs.getTitle());
        logger.debug("Total Number of VS in VMM = " + this.visualStyles.size());
        if (vs.getTitle() != null && vs.getTitle().equals(DEFAULT_STYLE_NAME)) {
            this.defaultStyle = vs;
        }
        CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
        eventHelper.fireEvent((CyEvent)new VisualStyleAddedEvent((VisualMappingManager)this, vs));
    }

    private String getSuggestedTitle(String title) {
        int i = 0;
        Object suggesteTitle = title;
        while (true) {
            suggesteTitle = title + "_" + new Integer(i).toString();
            boolean duplicated = false;
            for (VisualStyle exist_vs : this.getAllVisualStyles()) {
                if (!exist_vs.getTitle().equalsIgnoreCase((String)suggesteTitle)) continue;
                duplicated = true;
                break;
            }
            if (!duplicated) break;
            ++i;
        }
        return suggesteTitle;
    }

    private boolean hasDuplicatedTitle(VisualStyle vs) {
        if (this.getAllVisualStyles().size() == 0) {
            return false;
        }
        for (VisualStyle exist_vs : this.getAllVisualStyles()) {
            if (exist_vs.getTitle() == null || vs.getTitle() == null || !exist_vs.getTitle().equalsIgnoreCase(vs.getTitle())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<VisualStyle> getAllVisualStyles() {
        Object object = this.lock;
        synchronized (object) {
            return new HashSet<VisualStyle>(this.visualStyles);
        }
    }

    public VisualStyle getDefaultVisualStyle() {
        if (this.defaultStyle == null) {
            throw new IllegalStateException("No rendering engine is available, and cannot create default style.");
        }
        return this.defaultStyle;
    }

    public Set<VisualLexicon> getAllVisualLexicon() {
        LinkedHashSet<VisualLexicon> set = new LinkedHashSet<VisualLexicon>();
        CyApplicationManager appManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        for (NetworkViewRenderer nvRenderer : appManager.getNetworkViewRendererSet()) {
            VisualLexicon lexicon = nvRenderer.getRenderingEngineFactory("").getVisualLexicon();
            if (lexicon == null) continue;
            set.add(lexicon);
        }
        return set;
    }

    public VisualStyle getCurrentVisualStyle() {
        return this.currentStyle;
    }

    public void handleEvent(SetCurrentNetworkViewEvent e) {
        CyNetworkView view = e.getNetworkView();
        if (view == null) {
            return;
        }
        VisualStyle newStyle = this.getVisualStyle(view);
        if (newStyle != null) {
            this.setCurrentVisualStyle(newStyle);
        }
    }

    public void setCurrentVisualStyle(VisualStyle newStyle) {
        if (newStyle == null) {
            newStyle = this.defaultStyle;
        }
        boolean changed = !newStyle.equals(this.currentStyle);
        this.currentStyle = newStyle;
        if (changed) {
            CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
            eventHelper.fireEvent((CyEvent)new SetCurrentVisualStyleEvent((Object)this, this.currentStyle));
        }
    }
}

