/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyRow;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualLexiconNode;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualPropertyDependency;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.internal.ApplyHandler;
import org.cytoscape.view.vizmap.internal.VisualStyleImpl;

public abstract class AbstractApplyHandler<T extends CyIdentifiable>
implements ApplyHandler<T> {
    protected final VisualStyle style;
    protected final CyServiceRegistrar serviceRegistrar;
    protected final Class<T> targetDataType;
    protected final VisualProperty<?> rootVisualProperty;
    protected final Map<VisualProperty<?>, Set<VisualPropertyDependency<?>>> dependencyParents;
    protected final Map<VisualProperty<?>, Set<VisualPropertyDependency<?>>> dependencyChildren;
    protected volatile boolean updateDependencyMaps = true;

    AbstractApplyHandler(VisualStyle style, CyServiceRegistrar serviceRegistrar, Class<T> targetDataType, VisualProperty<?> rootVisualProperty) {
        this.style = style;
        this.serviceRegistrar = serviceRegistrar;
        this.targetDataType = targetDataType;
        this.rootVisualProperty = rootVisualProperty;
        this.dependencyParents = new ConcurrentHashMap(16, 0.75f, 2);
        this.dependencyChildren = new ConcurrentHashMap(16, 0.75f, 2);
    }

    public void setUpdateDependencyMaps() {
        this.updateDependencyMaps = true;
    }

    protected VisualLexicon getVisualLexicon() {
        CyApplicationManager appMgr = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        return appMgr.getCurrentNetworkViewRenderer().getRenderingEngineFactory("").getVisualLexicon();
    }

    @Override
    public void apply(CyRow row, View<T> view) {
        if (this.updateDependencyMaps) {
            this.updateDependencyMaps();
        }
        view.batch(v -> {
            view.clearVisualProperties();
            VisualLexicon lexicon = this.getVisualLexicon();
            LinkedList descendants = new LinkedList();
            descendants.addAll(lexicon.getVisualLexiconNode(this.rootVisualProperty).getChildren());
            while (!descendants.isEmpty()) {
                Object value;
                VisualLexiconNode node = (VisualLexiconNode)descendants.pop();
                VisualProperty vp = node.getVisualProperty();
                if (vp.getTargetDataType() != this.targetDataType) continue;
                VisualMappingFunction mapping = this.style.getVisualMappingFunction(vp);
                Object object = value = mapping != null ? mapping.getMappedValue(row) : null;
                if (value == null) {
                    this.applyDefaultValue(view, vp, lexicon);
                } else {
                    this.applyMappedValue(view, vp, value);
                }
                descendants.addAll(node.getChildren());
            }
        });
    }

    protected void applyDefaultValue(View<T> view, VisualProperty<?> vp, VisualLexicon lexicon) {
        Object value = this.style.getDefaultValue(vp);
        if (value == null) {
            ((VisualStyleImpl)this.style).getStyleDefaults().put(vp, vp.getDefault());
            value = this.style.getDefaultValue(vp);
        }
        Set<VisualPropertyDependency<?>> depSet = this.dependencyParents.get(vp);
        if (!this.isParentOfDependency(vp) && !this.isChildOfEnabledDependency(vp)) {
            if (!vp.shouldIgnoreDefault()) {
                view.setVisualProperty(vp, value);
            }
        } else if (depSet != null) {
            for (VisualPropertyDependency<?> dep : depSet) {
                if (!dep.isDependencyEnabled()) continue;
                this.propagateValue(view, vp, value, dep.getVisualProperties(), true);
            }
        }
    }

    protected void applyMappedValue(View<T> view, VisualProperty<?> vp, Object value) {
        Set<VisualPropertyDependency<?>> depSet = this.dependencyParents.get(vp);
        if (!this.isParentOfDependency(vp) && !this.isChildOfEnabledDependency(vp)) {
            view.setVisualProperty(vp, value);
        } else if (depSet != null) {
            for (VisualPropertyDependency<?> dep : depSet) {
                if (!dep.isDependencyEnabled()) continue;
                this.propagateValue(view, vp, value, dep.getVisualProperties(), false);
            }
        }
    }

    protected void propagateValue(View<? extends CyIdentifiable> view, VisualProperty<?> parent, Object value, Set<VisualProperty<?>> children, boolean isDefaultValue) {
        view.setVisualProperty(parent, value);
        for (VisualProperty<?> vp : children) {
            if (parent.getClass() != vp.getClass() || isDefaultValue && vp.shouldIgnoreDefault()) continue;
            view.setVisualProperty(vp, value);
        }
    }

    protected synchronized void updateDependencyMaps() {
        this.dependencyParents.clear();
        this.dependencyChildren.clear();
        for (VisualPropertyDependency dep : this.style.getAllVisualPropertyDependencies()) {
            VisualProperty parent = dep.getParentVisualProperty();
            Set<Object> depSet = this.dependencyParents.get(parent);
            if (depSet == null) {
                depSet = Collections.synchronizedSet(new HashSet());
                this.dependencyParents.put(parent, depSet);
            }
            depSet.add(dep);
            for (VisualProperty child : dep.getVisualProperties()) {
                Set<Object> childSet = this.dependencyChildren.get(child);
                if (childSet == null) {
                    childSet = Collections.synchronizedSet(new HashSet());
                    this.dependencyChildren.put(child, childSet);
                }
                childSet.add(dep);
            }
        }
        this.updateDependencyMaps = false;
    }

    protected boolean isParentOfDependency(VisualProperty<?> vp) {
        Set<VisualPropertyDependency<?>> set = this.dependencyParents.get(vp);
        return set != null && !set.isEmpty();
    }

    protected boolean isChildOfEnabledDependency(VisualProperty<?> vp) {
        Set<VisualPropertyDependency<?>> set = this.dependencyChildren.get(vp);
        if (set != null) {
            for (VisualPropertyDependency<?> dep : set) {
                if (!dep.isDependencyEnabled()) continue;
                return true;
            }
        }
        return false;
    }
}

