/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.browser.internal.view;

import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.events.SetCurrentNetworkEvent;
import org.cytoscape.application.events.SetCurrentNetworkListener;
import org.cytoscape.application.events.SetCurrentNetworkViewEvent;
import org.cytoscape.application.events.SetCurrentNetworkViewListener;
import org.cytoscape.application.events.SetCurrentTableEvent;
import org.cytoscape.application.events.SetCurrentTableListener;
import org.cytoscape.application.swing.CyAction;
import org.cytoscape.browser.internal.action.TaskFactoryTunableAction;
import org.cytoscape.browser.internal.task.DynamicTableTaskFactory;
import org.cytoscape.browser.internal.util.ViewUtil;
import org.cytoscape.browser.internal.view.AbstractTableBrowser;
import org.cytoscape.event.DebounceTimer;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.events.ColumnCreatedEvent;
import org.cytoscape.model.events.ColumnCreatedListener;
import org.cytoscape.model.events.ColumnDeletedEvent;
import org.cytoscape.model.events.ColumnDeletedListener;
import org.cytoscape.model.events.NetworkAddedEvent;
import org.cytoscape.model.events.NetworkAddedListener;
import org.cytoscape.model.events.NetworkDestroyedEvent;
import org.cytoscape.model.events.NetworkDestroyedListener;
import org.cytoscape.model.events.RowsCreatedEvent;
import org.cytoscape.model.events.RowsCreatedListener;
import org.cytoscape.model.events.RowsDeletedEvent;
import org.cytoscape.model.events.RowsDeletedListener;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.model.events.RowsSetListener;
import org.cytoscape.model.events.TableAddedEvent;
import org.cytoscape.model.events.TableAddedListener;
import org.cytoscape.model.events.TableDeletedEvent;
import org.cytoscape.model.events.TableDeletedListener;
import org.cytoscape.model.events.TablePrivacyChangedEvent;
import org.cytoscape.model.events.TablePrivacyChangedListener;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.events.SessionAboutToBeLoadedEvent;
import org.cytoscape.session.events.SessionAboutToBeLoadedListener;
import org.cytoscape.session.events.SessionAboutToBeSavedEvent;
import org.cytoscape.session.events.SessionAboutToBeSavedListener;
import org.cytoscape.session.events.SessionLoadedEvent;
import org.cytoscape.session.events.SessionLoadedListener;
import org.cytoscape.session.events.SessionSaveCancelledEvent;
import org.cytoscape.session.events.SessionSaveCancelledListener;
import org.cytoscape.session.events.SessionSavedEvent;
import org.cytoscape.session.events.SessionSavedListener;
import org.cytoscape.view.model.events.NetworkViewAddedEvent;
import org.cytoscape.view.model.events.NetworkViewAddedListener;
import org.cytoscape.view.model.events.NetworkViewDestroyedEvent;
import org.cytoscape.view.model.events.NetworkViewDestroyedListener;
import org.cytoscape.view.model.events.TableViewChangedEvent;
import org.cytoscape.view.model.events.TableViewChangedListener;
import org.cytoscape.view.model.table.CyTableView;
import org.cytoscape.work.TaskFactory;

public class ToolBarEnableUpdater
implements SessionAboutToBeLoadedListener,
SessionLoadedListener,
SessionAboutToBeSavedListener,
SessionSavedListener,
SessionSaveCancelledListener,
NetworkAddedListener,
NetworkDestroyedListener,
NetworkViewAddedListener,
NetworkViewDestroyedListener,
SetCurrentNetworkListener,
SetCurrentNetworkViewListener,
SetCurrentTableListener,
TableAddedListener,
TableDeletedListener,
TablePrivacyChangedListener,
ColumnCreatedListener,
ColumnDeletedListener,
RowsCreatedListener,
RowsDeletedListener,
RowsSetListener,
TableViewChangedListener {
    private final DebounceTimer debounceTimer = new DebounceTimer(100);
    private boolean loadingSession;
    private final Set<AbstractTableBrowser.TableToolBar> toolbars = new HashSet<AbstractTableBrowser.TableToolBar>();
    private final CyServiceRegistrar serviceRegistrar;

    public ToolBarEnableUpdater(Collection<AbstractTableBrowser.TableToolBar> toolbars, CyServiceRegistrar serviceRegistrar) {
        this.toolbars.addAll(toolbars);
        this.serviceRegistrar = serviceRegistrar;
    }

    public void handleEvent(SessionAboutToBeLoadedEvent e) {
        this.updateToolbar();
        this.loadingSession = true;
    }

    public void handleEvent(SessionLoadedEvent e) {
        this.loadingSession = false;
        this.updateToolbar();
    }

    public void handleEvent(SessionAboutToBeSavedEvent e) {
        this.updateToolbar();
    }

    public void handleEvent(SessionSavedEvent e) {
        this.updateToolbar();
    }

    public void handleEvent(SessionSaveCancelledEvent e) {
        this.updateToolbar();
    }

    public void handleEvent(SetCurrentNetworkEvent e) {
        if (!this.loadingSession) {
            this.updateToolbar();
        }
    }

    public void handleEvent(SetCurrentNetworkViewEvent e) {
        if (!this.loadingSession) {
            this.updateToolbar();
        }
    }

    public void handleEvent(NetworkAddedEvent e) {
        if (!this.loadingSession) {
            this.updateToolbar();
        }
    }

    public void handleEvent(NetworkViewAddedEvent e) {
        if (!this.loadingSession) {
            this.updateToolbar();
        }
    }

    public void handleEvent(NetworkDestroyedEvent e) {
        if (!this.loadingSession) {
            this.updateToolbar();
        }
    }

    public void handleEvent(NetworkViewDestroyedEvent e) {
        if (!this.loadingSession) {
            this.updateToolbar();
        }
    }

    public void handleEvent(SetCurrentTableEvent e) {
        if (!this.loadingSession) {
            this.updateToolbar();
        }
    }

    public void handleEvent(ColumnDeletedEvent e) {
        if (!this.loadingSession && ((CyTable)e.getSource()).equals(this.getCurrentTable())) {
            this.updateToolbar();
        }
    }

    public void handleEvent(ColumnCreatedEvent e) {
        if (!this.loadingSession && ((CyTable)e.getSource()).equals(this.getCurrentTable())) {
            this.updateToolbar();
        }
    }

    public void handleEvent(TableAddedEvent e) {
        if (!this.loadingSession && e.getTable().equals(this.getCurrentTable())) {
            this.updateToolbar();
        }
    }

    public void handleEvent(TableDeletedEvent e) {
        if (!this.loadingSession) {
            this.updateToolbar();
        }
    }

    public void handleEvent(TablePrivacyChangedEvent e) {
        if (!this.loadingSession && ((CyTable)e.getSource()).equals(this.getCurrentTable())) {
            this.updateToolbar();
        }
    }

    public void handleEvent(RowsCreatedEvent e) {
        if (!this.loadingSession && ((CyTable)e.getSource()).equals(this.getCurrentTable())) {
            this.updateToolbar();
        }
    }

    public void handleEvent(RowsDeletedEvent e) {
        if (!this.loadingSession && ((CyTable)e.getSource()).equals(this.getCurrentTable())) {
            this.updateToolbar();
        }
    }

    public void handleEvent(RowsSetEvent e) {
        if (!this.loadingSession && ((CyTable)e.getSource()).equals(this.getCurrentTable())) {
            this.updateToolbar();
        }
    }

    public void handleEvent(TableViewChangedEvent<?> e) {
        if (!this.loadingSession && ((CyTable)((CyTableView)e.getSource()).getModel()).equals(this.getCurrentTable())) {
            this.updateToolbar();
        }
    }

    private void updateToolbar() {
        this.debounceTimer.debounce(() -> ViewUtil.invokeOnEDT(() -> {
            for (AbstractTableBrowser.TableToolBar tb : this.toolbars) {
                if (!tb.isShowing()) continue;
                CyTable table = tb.getCurrentTable();
                for (CyAction action : tb.getAllToolBarActions()) {
                    if (action instanceof TaskFactoryTunableAction) {
                        TaskFactory tf = ((TaskFactoryTunableAction)action).getTaskFactory();
                        if (!(tf instanceof DynamicTableTaskFactory)) continue;
                        Component comp = tb.getComponent(action);
                        boolean ready = ((DynamicTableTaskFactory)tf).isReady(table);
                        comp.setEnabled(ready);
                        boolean applicable = ((DynamicTableTaskFactory)tf).isApplicable(table);
                        comp.setVisible(applicable);
                        continue;
                    }
                    action.updateEnableState();
                }
            }
        }));
    }

    private CyTable getCurrentTable() {
        return ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentTable();
    }
}

