/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.browser.internal.view;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyDisposable;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.table.CyTableView;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.property.table.BasicTableVisualLexicon;
import org.cytoscape.view.presentation.property.table.CellFormat;
import org.cytoscape.view.presentation.property.table.TableMode;

public class TableRenderer
implements CyDisposable {
    private RenderingEngine<CyTable> renderingEngine;
    private JComponent component;

    public TableRenderer(RenderingEngine<CyTable> renderingEngine, JComponent component) {
        this.renderingEngine = renderingEngine;
        this.component = component;
    }

    public RenderingEngine<CyTable> getRenderingEngine() {
        return this.renderingEngine;
    }

    public JComponent getComponent() {
        return this.component;
    }

    public CyTableView getTableView() {
        return this.renderingEngine != null ? (CyTableView)this.renderingEngine.getViewModel() : null;
    }

    public CyTable getDataTable() {
        return (CyTable)this.renderingEngine.getViewModel().getModel();
    }

    public void setColumnVisible(String name, boolean visible) {
        View colView = this.getTableView().getColumnView(name);
        TableRenderer.setColumnVisible((View<CyColumn>)colView, visible);
    }

    public static void setColumnVisible(View<CyColumn> colView, boolean visible) {
        if (colView != null) {
            colView.setLockedValue(BasicTableVisualLexicon.COLUMN_VISIBLE, (Object)visible);
        }
    }

    public boolean isColumnVisible(View<CyColumn> colView) {
        return colView != null ? ((Boolean)colView.getVisualProperty(BasicTableVisualLexicon.COLUMN_VISIBLE)).booleanValue() : ((Boolean)BasicTableVisualLexicon.COLUMN_VISIBLE.getDefault()).booleanValue();
    }

    public void setColumnGravity(String name, double grav) {
        View colView = this.getTableView().getColumnView(name);
        if (colView != null) {
            colView.setLockedValue(BasicTableVisualLexicon.COLUMN_GRAVITY, (Object)grav);
        }
    }

    public List<View<CyColumn>> getColumnViewsSortedByGravity() {
        ArrayList<View<CyColumn>> sortedColViews = new ArrayList<View<CyColumn>>(this.getTableView().getColumnViews());
        sortedColViews.sort((cv1, cv2) -> {
            double grav1 = (Double)cv1.getVisualProperty(BasicTableVisualLexicon.COLUMN_GRAVITY);
            double grav2 = (Double)cv2.getVisualProperty(BasicTableVisualLexicon.COLUMN_GRAVITY);
            return Double.compare(grav1, grav2);
        });
        return sortedColViews;
    }

    public TableMode getTableMode() {
        return (TableMode)this.getTableView().getVisualProperty(BasicTableVisualLexicon.TABLE_VIEW_MODE);
    }

    public void setTableMode(TableMode mode) {
        this.getTableView().setVisualProperty(BasicTableVisualLexicon.TABLE_VIEW_MODE, (Object)mode);
    }

    public static TableMode getDefaultTableMode() {
        return (TableMode)BasicTableVisualLexicon.TABLE_VIEW_MODE.getDefault();
    }

    public String getColumnFormat(String name) {
        View colView = this.getTableView().getColumnView(name);
        CellFormat f = (CellFormat)colView.getVisualProperty(BasicTableVisualLexicon.COLUMN_FORMAT);
        if (f == null) {
            return null;
        }
        String format = f.getFormat();
        if (format == null || format.isBlank()) {
            return null;
        }
        return format;
    }

    public void setColumnFormat(String name, String format) {
        View colView = this.getTableView().getColumnView(name);
        if (colView != null) {
            colView.setLockedValue(BasicTableVisualLexicon.COLUMN_FORMAT, (Object)new CellFormat(format));
        }
    }

    public void setTextWrap(String name, boolean wrap) {
        View colView = this.getTableView().getColumnView(name);
        if (colView != null) {
            colView.setLockedValue(BasicTableVisualLexicon.COLUMN_TEXT_WRAPPED, (Object)wrap);
        }
    }

    public boolean isTextWrap(String name) {
        View colView = this.getTableView().getColumnView(name);
        return colView != null ? ((Boolean)colView.getVisualProperty(BasicTableVisualLexicon.COLUMN_TEXT_WRAPPED)).booleanValue() : ((Boolean)BasicTableVisualLexicon.COLUMN_TEXT_WRAPPED.getDefault()).booleanValue();
    }

    public void dispose() {
        try {
            this.renderingEngine.dispose();
        }
        finally {
            this.component = null;
            this.renderingEngine = null;
        }
    }
}

